
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight that the offer applies to.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightInfoAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:boolean" name="AllSegmentInd" minOccurs="0"/>
 *       &lt;xs:element ref="ns:FlightSegmentReference" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;/xs:choice>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:boolean" name="AllOriginDestinationInd" minOccurs="0"/>
 *       &lt;xs:element ref="ns:OriginDestinationReferences" minOccurs="0"/>
 *     &lt;/xs:choice>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:boolean" name="AllFlightInd" minOccurs="0"/>
 *       &lt;xs:element ref="ns:FlightReferences" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightInfoAssocType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ALL_SEGMENT_IND_CHOICE = 0;
    private static final int FLIGHT_SEGMENT_REFERENCE_LIST_CHOICE = 1;
    private Boolean allSegmentInd;
    private List<FlightSegmentReference> flightSegmentReferenceList = new ArrayList<FlightSegmentReference>();
    private int choiceSelect1 = -1;
    private static final int ALL_ORIGIN_DESTINATION_IND_CHOICE = 0;
    private static final int ORIGIN_DESTINATION_REFERENCES_CHOICE = 1;
    private Boolean allOriginDestinationInd;
    private OriginDestinationReferences originDestinationReferences;
    private int choiceSelect2 = -1;
    private static final int ALL_FLIGHT_IND_CHOICE = 0;
    private static final int FLIGHT_REFERENCES_CHOICE = 1;
    private Boolean allFlightInd;
    private FlightReferences flightReferences;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AllSegmentInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllSegmentInd() {
        return choiceSelect == ALL_SEGMENT_IND_CHOICE;
    }

    /** 
     * Get the 'AllSegmentInd' element value. When true, this Simple Fare Offer applies to all specified flight Segments.
     * 
     * @return value
     */
    public Boolean getAllSegmentInd() {
        return allSegmentInd;
    }

    /** 
     * Set the 'AllSegmentInd' element value. When true, this Simple Fare Offer applies to all specified flight Segments.
     * 
     * @param allSegmentInd
     */
    public void setAllSegmentInd(Boolean allSegmentInd) {
        setChoiceSelect(ALL_SEGMENT_IND_CHOICE);
        this.allSegmentInd = allSegmentInd;
    }

    /** 
     * Check if FlightSegmentReferenceList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFlightSegmentReferenceList() {
        return choiceSelect == FLIGHT_SEGMENT_REFERENCE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'FlightSegmentReference' element items. Association to to single Flight  segment instance(s). Example: segment1
     * 
     * @return list
     */
    public List<FlightSegmentReference> getFlightSegmentReferenceList() {
        return flightSegmentReferenceList;
    }

    /** 
     * Set the list of 'FlightSegmentReference' element items. Association to to single Flight  segment instance(s). Example: segment1
     * 
     * @param list
     */
    public void setFlightSegmentReferenceList(List<FlightSegmentReference> list) {
        setChoiceSelect(FLIGHT_SEGMENT_REFERENCE_LIST_CHOICE);
        flightSegmentReferenceList = list;
    }

    private void setChoiceSelect1(int choice) {
        if (choiceSelect1 == -1) {
            choiceSelect1 = choice;
        } else if (choiceSelect1 != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect1() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect1() {
        choiceSelect1 = -1;
    }

    /** 
     * Check if AllOriginDestinationInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllOriginDestinationInd() {
        return choiceSelect1 == ALL_ORIGIN_DESTINATION_IND_CHOICE;
    }

    /** 
     * Get the 'AllOriginDestinationInd' element value. When true, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
     * 
     * @return value
     */
    public Boolean getAllOriginDestinationInd() {
        return allOriginDestinationInd;
    }

    /** 
     * Set the 'AllOriginDestinationInd' element value. When true, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
     * 
     * @param allOriginDestinationInd
     */
    public void setAllOriginDestinationInd(Boolean allOriginDestinationInd) {
        setChoiceSelect1(ALL_ORIGIN_DESTINATION_IND_CHOICE);
        this.allOriginDestinationInd = allOriginDestinationInd;
    }

    /** 
     * Check if OriginDestinationReferences is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOriginDestinationReferences() {
        return choiceSelect1 == ORIGIN_DESTINATION_REFERENCES_CHOICE;
    }

    /** 
     * Get the 'OriginDestinationReferences' element value.
     * 
     * @return value
     */
    public OriginDestinationReferences getOriginDestinationReferences() {
        return originDestinationReferences;
    }

    /** 
     * Set the 'OriginDestinationReferences' element value.
     * 
     * @param originDestinationReferences
     */
    public void setOriginDestinationReferences(
            OriginDestinationReferences originDestinationReferences) {
        setChoiceSelect1(ORIGIN_DESTINATION_REFERENCES_CHOICE);
        this.originDestinationReferences = originDestinationReferences;
    }

    private void setChoiceSelect2(int choice) {
        if (choiceSelect2 == -1) {
            choiceSelect2 = choice;
        } else if (choiceSelect2 != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect2() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect2() {
        choiceSelect2 = -1;
    }

    /** 
     * Check if AllFlightInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllFlightInd() {
        return choiceSelect2 == ALL_FLIGHT_IND_CHOICE;
    }

    /** 
     * Get the 'AllFlightInd' element value. When true, this Simple Fare Offer applies to all specified flights.
     * 
     * @return value
     */
    public Boolean getAllFlightInd() {
        return allFlightInd;
    }

    /** 
     * Set the 'AllFlightInd' element value. When true, this Simple Fare Offer applies to all specified flights.
     * 
     * @param allFlightInd
     */
    public void setAllFlightInd(Boolean allFlightInd) {
        setChoiceSelect2(ALL_FLIGHT_IND_CHOICE);
        this.allFlightInd = allFlightInd;
    }

    /** 
     * Check if FlightReferences is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFlightReferences() {
        return choiceSelect2 == FLIGHT_REFERENCES_CHOICE;
    }

    /** 
     * Get the 'FlightReferences' element value.
     * 
     * @return value
     */
    public FlightReferences getFlightReferences() {
        return flightReferences;
    }

    /** 
     * Set the 'FlightReferences' element value.
     * 
     * @param flightReferences
     */
    public void setFlightReferences(FlightReferences flightReferences) {
        setChoiceSelect2(FLIGHT_REFERENCES_CHOICE);
        this.flightReferences = flightReferences;
    }
}
