
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FLIGHT Order Item.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:GenericPriceType" name="Price" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightType" name="OriginDestination" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightItemType implements Serializable
{
    private GenericPriceType price;
    private List<FlightType> originDestinationList = new ArrayList<FlightType>();
    private FareDetailType fareDetail;
    private String refs;

    /** 
     * Get the 'Price' element value. Flight Pricing.
     * 
     * @return value
     */
    public GenericPriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Flight Pricing.
     * 
     * @param price
     */
    public void setPrice(GenericPriceType price) {
        this.price = price;
    }

    /** 
     * Get the list of 'OriginDestination' element items. Flight Origin/ Destination information.
     * 
     * @return list
     */
    public List<FlightType> getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items. Flight Origin/ Destination information.
     * 
     * @param list
     */
    public void setOriginDestinationList(List<FlightType> list) {
        originDestinationList = list;
    }

    /** 
     * Get the 'FareDetail' element value. Fare Detail.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value. Fare Detail.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
