
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Flight Origin with Additional Location Preference and Date/Time Qualifiers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FltDepartQualifiedQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="LocationCode" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class LocationCode -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:date" name="Date" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Time" minOccurs="0"/>
 *     &lt;xs:element name="LeadPricing" minOccurs="0">
 *       &lt;!-- Reference to inner class LeadPricing -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FltDepartQualifiedQueryType implements Serializable
{
    private List<LocationCode> locationCodeList = new ArrayList<LocationCode>();
    private Date date;
    private String time;
    private LeadPricing leadPricing;
    private String refs;

    /** 
     * Get the list of 'LocationCode' element items.
     * 
     * @return list
     */
    public List<LocationCode> getLocationCodeList() {
        return locationCodeList;
    }

    /** 
     * Set the list of 'LocationCode' element items.
     * 
     * @param list
     */
    public void setLocationCodeList(List<LocationCode> list) {
        locationCodeList = list;
    }

    /** 
     * Get the 'Date' element value. Departure date. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. Departure date. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 
     * Get the 'Time' element value. Departure time. Example: 09:15

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @return value
     */
    public String getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. Departure time. Example: 09:15

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @param time
     */
    public void setTime(String time) {
        this.time = time;
    }

    /** 
     * Get the 'LeadPricing' element value.
     * 
     * @return value
     */
    public LeadPricing getLeadPricing() {
        return leadPricing;
    }

    /** 
     * Set the 'LeadPricing' element value.
     * 
     * @param leadPricing
     */
    public void setLeadPricing(LeadPricing leadPricing) {
        this.leadPricing = leadPricing;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Airport or a city code. Use a three letter  location identifier assigned according to the IATA Resolution 763.  Refer to IATA Airline Coding Directory . Example: TPA
    Notes:

    1. A proximity search, e.g. within 25 miles, may be specified using the Radius attributes.

    2. A preference level for the specified location code may specified using the Preference attributes.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationCode" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *         &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class LocationCode implements Serializable
    {
        private String string;
        private PreferenceAttrGroup preferenceAttrGroup;
        private RadiusAttrGroup radiusAttrGroup;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value. Preference Level for specified Airport or City code.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value. Preference Level for specified Airport or City code.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }

        /** 
         * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
         * 
         * @return value
         */
        public RadiusAttrGroup getRadiusAttrGroup() {
            return radiusAttrGroup;
        }

        /** 
         * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
         * 
         * @param radiusAttrGroup
         */
        public void setRadiusAttrGroup(RadiusAttrGroup radiusAttrGroup) {
            this.radiusAttrGroup = radiusAttrGroup;
        }
    }
    /** 
     * Lead Pricing information used in calendar shopping scenarios.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LeadPricing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice maxOccurs="2">
     *       &lt;!-- Reference to inner class LeadPricingInner -->
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class LeadPricing implements Serializable
    {
        private List<LeadPricingInner> leadPricingList = new ArrayList<LeadPricingInner>();

        /** 
         * Get the list of 'LeadPricing' element items.
         * 
         * @return list
         */
        public List<LeadPricingInner> getLeadPricingList() {
            return leadPricingList;
        }

        /** 
         * Set the list of 'LeadPricing' element items.
         * 
         * @param list
         */
        public void setLeadPricingList(List<LeadPricingInner> list) {
            leadPricingList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
         *   &lt;xs:element ref="ns:LeadDatePeriod"/>
         *   &lt;xs:element ref="ns:LeadTimePeriod"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class LeadPricingInner implements Serializable
        {
            private int leadPricingListSelect = -1;
            private static final int LEAD_DATE_PERIOD_CHOICE = 0;
            private static final int LEAD_TIME_PERIOD_CHOICE = 1;
            private LeadDatePeriodType leadDatePeriod;
            private LeadTimePeriodType leadTimePeriod;

            private void setLeadPricingListSelect(int choice) {
                if (leadPricingListSelect == -1) {
                    leadPricingListSelect = choice;
                } else if (leadPricingListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearLeadPricingListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearLeadPricingListSelect() {
                leadPricingListSelect = -1;
            }

            /** 
             * Check if LeadDatePeriod is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifLeadDatePeriod() {
                return leadPricingListSelect == LEAD_DATE_PERIOD_CHOICE;
            }

            /** 
             * Get the 'LeadDatePeriod' element value.
             * 
             * @return value
             */
            public LeadDatePeriodType getLeadDatePeriod() {
                return leadDatePeriod;
            }

            /** 
             * Set the 'LeadDatePeriod' element value.
             * 
             * @param leadDatePeriod
             */
            public void setLeadDatePeriod(LeadDatePeriodType leadDatePeriod) {
                setLeadPricingListSelect(LEAD_DATE_PERIOD_CHOICE);
                this.leadDatePeriod = leadDatePeriod;
            }

            /** 
             * Check if LeadTimePeriod is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifLeadTimePeriod() {
                return leadPricingListSelect == LEAD_TIME_PERIOD_CHOICE;
            }

            /** 
             * Get the 'LeadTimePeriod' element value.
             * 
             * @return value
             */
            public LeadTimePeriodType getLeadTimePeriod() {
                return leadTimePeriod;
            }

            /** 
             * Set the 'LeadTimePeriod' element value.
             * 
             * @param leadTimePeriod
             */
            public void setLeadTimePeriod(LeadTimePeriodType leadTimePeriod) {
                setLeadPricingListSelect(LEAD_TIME_PERIOD_CHOICE);
                this.leadTimePeriod = leadTimePeriod;
            }
        }
    }
}
