
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Maximum Flight Segment Travel Time.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FltSegmentMaxTimePreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="MaxFlightTime">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:decimal" name="TimeAmount"/>
 *           &lt;xs:element name="UOM">
 *             &lt;xs:simpleType>
 *               &lt;!-- Reference to inner class UOM -->
 *             &lt;/xs:simpleType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FltSegmentMaxTimePreferencesType implements Serializable
{
    private BigDecimal maxFlightTimeTimeAmount;
    private UOM maxFlightTimeUOM;
    private PreferenceAttrGroup preferenceAttrGroup;
    private String refs;

    /** 
     * Get the 'TimeAmount' element value. Travel time (unit) Value.
    							Example: 45, 45 (Minutes)
     * 
     * @return value
     */
    public BigDecimal getMaxFlightTimeTimeAmount() {
        return maxFlightTimeTimeAmount;
    }

    /** 
     * Set the 'TimeAmount' element value. Travel time (unit) Value.
    							Example: 45, 45 (Minutes)
     * 
     * @param maxFlightTimeTimeAmount
     */
    public void setMaxFlightTimeTimeAmount(BigDecimal maxFlightTimeTimeAmount) {
        this.maxFlightTimeTimeAmount = maxFlightTimeTimeAmount;
    }

    /** 
     * Get the 'UOM' element value. Travel time unit of measure. Example: Minutes, Hours, Days
     * 
     * @return value
     */
    public UOM getMaxFlightTimeUOM() {
        return maxFlightTimeUOM;
    }

    /** 
     * Set the 'UOM' element value. Travel time unit of measure. Example: Minutes, Hours, Days
     * 
     * @param maxFlightTimeUOM
     */
    public void setMaxFlightTimeUOM(UOM maxFlightTimeUOM) {
        this.maxFlightTimeUOM = maxFlightTimeUOM;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Days"/>
     *     &lt;xs:enumeration value="Hours"/>
     *     &lt;xs:enumeration value="Minutes"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum UOM implements Serializable {
        DAYS("Days"), HOURS("Hours"), MINUTES("Minutes");
        private final String value;

        private UOM(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static UOM convert(String value) {
            for (UOM inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
