
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PARTNER ROLE: FULFILLMENT PARTNER, Core Representation.

 Notes:
 1. This is a representation of common (role-agnostic) properties associated with this Actor definition.
 2. This type is used as (derived) base type for all Roles associated with this Actor.
 3. This type is derived from PartnerCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FulfillmentPartnerType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:PartnerCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Fulfillments" minOccurs="0">
 *           &lt;!-- Reference to inner class Fulfillments -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FulfillmentPartnerType extends PartnerCoreRepType implements
    Serializable
{
    private Fulfillments fulfillments;

    /** 
     * Get the 'Fulfillments' element value.
     * 
     * @return value
     */
    public Fulfillments getFulfillments() {
        return fulfillments;
    }

    /** 
     * Set the 'Fulfillments' element value.
     * 
     * @param fulfillments
     */
    public void setFulfillments(Fulfillments fulfillments) {
        this.fulfillments = fulfillments;
    }
    /** 
     * Offer and Order Fulfillment(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fulfillments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Fulfillment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Fulfillment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Fulfillments implements Serializable
    {
        private List<Fulfillment> fulfillmentList = new ArrayList<Fulfillment>();

        /** 
         * Get the list of 'Fulfillment' element items.
         * 
         * @return list
         */
        public List<Fulfillment> getFulfillmentList() {
            return fulfillmentList;
        }

        /** 
         * Set the list of 'Fulfillment' element items.
         * 
         * @param list
         */
        public void setFulfillmentList(List<Fulfillment> list) {
            fulfillmentList = list;
        }
        /** 
         * Fulfillment detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fulfillment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OfferValidDates" minOccurs="0">
         *         &lt;!-- Reference to inner class OfferValidDates -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Location" minOccurs="0">
         *         &lt;!-- Reference to inner class Location -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Fulfillment implements Serializable
        {
            private OfferValidDates offerValidDates;
            private Location location;
            private String refs;

            /** 
             * Get the 'OfferValidDates' element value.
             * 
             * @return value
             */
            public OfferValidDates getOfferValidDates() {
                return offerValidDates;
            }

            /** 
             * Set the 'OfferValidDates' element value.
             * 
             * @param offerValidDates
             */
            public void setOfferValidDates(OfferValidDates offerValidDates) {
                this.offerValidDates = offerValidDates;
            }

            /** 
             * Get the 'Location' element value.
             * 
             * @return value
             */
            public Location getLocation() {
                return location;
            }

            /** 
             * Set the 'Location' element value.
             * 
             * @param location
             */
            public void setLocation(Location location) {
                this.location = location;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Fulfillment Period.

            Note: This is the start and end date/time period(s) the service may be fullfilled or used.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferValidDates" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:CoreDateGrpType" name="Start" minOccurs="0"/>
             *       &lt;xs:element type="ns:CoreDateGrpType" name="End" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OfferValidDates implements Serializable
            {
                private CoreDateGrpType start;
                private CoreDateGrpType end;

                /** 
                 * Get the 'Start' element value. The EARLIEST date the associated optional service is available or may be used.  Example: 2017-01-13
                 * 
                 * @return value
                 */
                public CoreDateGrpType getStart() {
                    return start;
                }

                /** 
                 * Set the 'Start' element value. The EARLIEST date the associated optional service is available or may be used.  Example: 2017-01-13
                 * 
                 * @param start
                 */
                public void setStart(CoreDateGrpType start) {
                    this.start = start;
                }

                /** 
                 * Get the 'End' element value. The LATEST date the associated optional service is available or may be used. Example: 2017-03-13
                 * 
                 * @return value
                 */
                public CoreDateGrpType getEnd() {
                    return end;
                }

                /** 
                 * Set the 'End' element value. The LATEST date the associated optional service is available or may be used. Example: 2017-03-13
                 * 
                 * @param end
                 */
                public void setEnd(CoreDateGrpType end) {
                    this.end = end;
                }
            }
            /** 
             * Information about the location where the service will be fulfilled.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:AirportCode"/>
             *       &lt;xs:element ref="ns:StructuredAddress"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Location implements Serializable
            {
                private int locationSelect = -1;
                private static final int AIRPORT_CODE_CHOICE = 0;
                private static final int STRUCTURED_ADDRESS_CHOICE = 1;
                private AirportCode airportCode;
                private StructuredAddress structuredAddress;

                private void setLocationSelect(int choice) {
                    if (locationSelect == -1) {
                        locationSelect = choice;
                    } else if (locationSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearLocationSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearLocationSelect() {
                    locationSelect = -1;
                }

                /** 
                 * Check if AirportCode is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAirportCode() {
                    return locationSelect == AIRPORT_CODE_CHOICE;
                }

                /** 
                 * Get the 'AirportCode' element value.
                 * 
                 * @return value
                 */
                public AirportCode getAirportCode() {
                    return airportCode;
                }

                /** 
                 * Set the 'AirportCode' element value.
                 * 
                 * @param airportCode
                 */
                public void setAirportCode(AirportCode airportCode) {
                    setLocationSelect(AIRPORT_CODE_CHOICE);
                    this.airportCode = airportCode;
                }

                /** 
                 * Check if StructuredAddress is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifStructuredAddress() {
                    return locationSelect == STRUCTURED_ADDRESS_CHOICE;
                }

                /** 
                 * Get the 'StructuredAddress' element value.
                 * 
                 * @return value
                 */
                public StructuredAddress getStructuredAddress() {
                    return structuredAddress;
                }

                /** 
                 * Set the 'StructuredAddress' element value.
                 * 
                 * @param structuredAddress
                 */
                public void setStructuredAddress(
                        StructuredAddress structuredAddress) {
                    setLocationSelect(STRUCTURED_ADDRESS_CHOICE);
                    this.structuredAddress = structuredAddress;
                }
            }
        }
    }
}
