
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Specifies the content value(s) for the gender code BDT.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GenderCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Female"/>
 *     &lt;xs:enumeration value="Male"/>
 *     &lt;xs:enumeration value="Unspecified"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum GenderCodeContentType implements Serializable {
    FEMALE("Female"), MALE("Male"), UNSPECIFIED("Unspecified");
    private final String value;

    private GenderCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static GenderCodeContentType convert(String value) {
        for (GenderCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
