
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeoSpecCode">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute use="required" name="GeoSpecCodeType">
 *           &lt;xs:simpleType>
 *             &lt;!-- Reference to inner class GeoSpecCodeType -->
 *           &lt;/xs:simpleType>
 *         &lt;/xs:attribute>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class GeoSpecCode implements Serializable
{
    private String string;
    private GeoSpecCodeType geoSpecCodeType;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'GeoSpecCodeType' attribute value. Further defines GeoSpecCode as Airport, City, State, Country, Sub-Area, Area                                                            A = Area                         S = State                         Z = Sub Area                   C = City                            P = Airport                         N = Country                   
     * 
     * @return value
     */
    public GeoSpecCodeType getGeoSpecCodeType() {
        return geoSpecCodeType;
    }

    /** 
     * Set the 'GeoSpecCodeType' attribute value. Further defines GeoSpecCode as Airport, City, State, Country, Sub-Area, Area                                                            A = Area                         S = State                         Z = Sub Area                   C = City                            P = Airport                         N = Country                   
     * 
     * @param geoSpecCodeType
     */
    public void setGeoSpecCodeType(GeoSpecCodeType geoSpecCodeType) {
        this.geoSpecCodeType = geoSpecCodeType;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="A"/>
     *     &lt;xs:enumeration value="S"/>
     *     &lt;xs:enumeration value="Z"/>
     *     &lt;xs:enumeration value="C"/>
     *     &lt;xs:enumeration value="P"/>
     *     &lt;xs:enumeration value="N"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum GeoSpecCodeType implements Serializable {
        A, S, Z, C, P, N
    }
}
