
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Geographic Specification information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeographicSpecificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:GeoSpecCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element name="Coordinates" minOccurs="0">
 *       &lt;!-- Reference to inner class Coordinates -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GeographicSpecificationType implements Serializable
{
    private List<GeoSpecCode> geoSpecCodeList = new ArrayList<GeoSpecCode>();
    private Coordinates coordinates;

    /** 
     * Get the list of 'GeoSpecCode' element items. Indicates whether a system may or may not send NDC requests based on geographic specifications. Users may enter a location here which is further defined by the @Type.                                                             Valid area values include 1 = Western Hemisphere 2 = Europe, Africa, and the Near East 3 = Far East, Australia, and Pacific                                                                   Valid sub areas are Standard ISO/IATA sub area code                                               Valid airport and city codes are a three letter  location identifier assigned according to the IATA Resolution 763.  Refer to IATA Airline Coding Directory . Example: TPA    
      
     * 
     * @return list
     */
    public List<GeoSpecCode> getGeoSpecCodeList() {
        return geoSpecCodeList;
    }

    /** 
     * Set the list of 'GeoSpecCode' element items. Indicates whether a system may or may not send NDC requests based on geographic specifications. Users may enter a location here which is further defined by the @Type.                                                             Valid area values include 1 = Western Hemisphere 2 = Europe, Africa, and the Near East 3 = Far East, Australia, and Pacific                                                                   Valid sub areas are Standard ISO/IATA sub area code                                               Valid airport and city codes are a three letter  location identifier assigned according to the IATA Resolution 763.  Refer to IATA Airline Coding Directory . Example: TPA    
      
     * 
     * @param list
     */
    public void setGeoSpecCodeList(List<GeoSpecCode> list) {
        geoSpecCodeList = list;
    }

    /** 
     * Get the 'Coordinates' element value.
     * 
     * @return value
     */
    public Coordinates getCoordinates() {
        return coordinates;
    }

    /** 
     * Set the 'Coordinates' element value.
     * 
     * @param coordinates
     */
    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }
    /** 
     * Coordinates (Latitude, Longitude, as defined in the Data Dictionary)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coordinates" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:PositionType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="CoordinateRadius" minOccurs="0">
     *             &lt;!-- Reference to inner class CoordinateRadius -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Coordinates extends PositionType implements
        Serializable
    {
        private CoordinateRadius coordinateRadius;

        /** 
         * Get the 'CoordinateRadius' element value.
         * 
         * @return value
         */
        public CoordinateRadius getCoordinateRadius() {
            return coordinateRadius;
        }

        /** 
         * Set the 'CoordinateRadius' element value.
         * 
         * @param coordinateRadius
         */
        public void setCoordinateRadius(CoordinateRadius coordinateRadius) {
            this.coordinateRadius = coordinateRadius;
        }
        /** 
         * Radius (in miles) to use in conjunction with coordinates above
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CoordinateRadius" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:decimal">
         *         &lt;xs:attribute type="xs:anySimpleType" name="UOM"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CoordinateRadius implements Serializable
        {
            private BigDecimal decimal;
            private String UOM;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public BigDecimal getDecimal() {
                return decimal;
            }

            /** 
             * Set the extension value.
             * 
             * @param decimal
             */
            public void setDecimal(BigDecimal decimal) {
                this.decimal = decimal;
            }

            /** 
             * Get the 'UOM' attribute value. Unit of measure to specify Kilometers and miles.
             * 
             * @return value
             */
            public String getUOM() {
                return UOM;
            }

            /** 
             * Set the 'UOM' attribute value. Unit of measure to specify Kilometers and miles.
             * 
             * @param UOM
             */
            public void setUOM(String UOM) {
                this.UOM = UOM;
            }
        }
    }
}
