
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Contains information on a Group, such as Group Name, number in party, and contacts for the group.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name"/>
 *     &lt;xs:element type="xs:string" name="PassengerCount"/>
 *     &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GroupType implements Serializable
{
    private String name;
    private String passengerCount;
    private Contacts contacts;
    private ObjectKeyAttrGroup objectKeyAttrGroup;

    /** 
     * Get the 'Name' element value. Group Name. Example: ABC Tour Club
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Group Name. Example: ABC Tour Club
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'PassengerCount' element value. PassengerCount. Example: 12
     * 
     * @return value
     */
    public String getPassengerCount() {
        return passengerCount;
    }

    /** 
     * Set the 'PassengerCount' element value. PassengerCount. Example: 12
     * 
     * @param passengerCount
     */
    public void setPassengerCount(String passengerCount) {
        this.passengerCount = passengerCount;
    }

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }

    /** 
     * Get the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
        return objectKeyAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @param objectKeyAttrGroup
     */
    public void setObjectKeyAttrGroup(ObjectKeyAttrGroup objectKeyAttrGroup) {
        this.objectKeyAttrGroup = objectKeyAttrGroup;
    }
}
