
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Unique image ID. Examples: IMG713, SFO_LOUNGE
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ImageID">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute type="xs:string" name="Owner"/>
 *         &lt;xs:attribute type="xs:string" name="MediaDimensionFormat"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ImageID implements Serializable
{
    private String string;
    private String owner;
    private String mediaDimensionFormat;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'MediaDimensionFormat' attribute value. "The “Format” is the “CREATIVE UNIT NAME”, Example: (Billboard, Filmstrip, Portrait, Pushdown, Medium Rectangle, Rectangle, Half Page ,…) IATA codeset MDF. Please refer to http://www.iab.com/wp-content/uploads/2015/11/IAB_Display_Mobile_Creative_Guidelines_HTML5_2015.pdf"
     * 
     * @return value
     */
    public String getMediaDimensionFormat() {
        return mediaDimensionFormat;
    }

    /** 
     * Set the 'MediaDimensionFormat' attribute value. "The “Format” is the “CREATIVE UNIT NAME”, Example: (Billboard, Filmstrip, Portrait, Pushdown, Medium Rectangle, Rectangle, Half Page ,…) IATA codeset MDF. Please refer to http://www.iab.com/wp-content/uploads/2015/11/IAB_Display_Mobile_Creative_Guidelines_HTML5_2015.pdf"
     * 
     * @param mediaDimensionFormat
     */
    public void setMediaDimensionFormat(String mediaDimensionFormat) {
        this.mediaDimensionFormat = mediaDimensionFormat;
    }
}
