
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Incentive Program Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IncentiveProgramType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name"/>
 *     &lt;xs:element name="AccountID">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:AirlineID"/>
 *     &lt;xs:element name="MemberStatus" minOccurs="0">
 *       &lt;!-- Reference to inner class MemberStatus -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class IncentiveProgramType implements Serializable
{
    private String name;
    private String accountIDString;
    private String accountIDRefs;
    private AirlineIDType airlineID;
    private MemberStatus memberStatus;
    private String refs;

    /** 
     * Get the 'Name' element value. Incentive program name.
    Example: RFSB (Reward for small businesses)
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Incentive program name.
    Example: RFSB (Reward for small businesses)
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getAccountIDString() {
        return accountIDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param accountIDString
     */
    public void setAccountIDString(String accountIDString) {
        this.accountIDString = accountIDString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getAccountIDRefs() {
        return accountIDRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param accountIDRefs
     */
    public void setAccountIDRefs(String accountIDRefs) {
        this.accountIDRefs = accountIDRefs;
    }

    /** 
     * Get the 'AirlineID' element value. Designator of airline offering the incentive program. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value. Designator of airline offering the incentive program. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'MemberStatus' element value.
     * 
     * @return value
     */
    public MemberStatus getMemberStatus() {
        return memberStatus;
    }

    /** 
     * Set the 'MemberStatus' element value.
     * 
     * @param memberStatus
     */
    public void setMemberStatus(MemberStatus memberStatus) {
        this.memberStatus = memberStatus;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Member or participant status within the program. Examples: VP, DIRECTOR, EXEC
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MemberStatus" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class MemberStatus implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
