
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * A single human being as distinct from a group, class, or family.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IndividualType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Birthplace" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:GenderCodeContentType" name="Gender" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="NameTitle" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="Surname" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SurnameSuffix" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="IndividualID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IndividualType implements Serializable
{
    private Date birthdate;
    private String birthplace;
    private GenderCodeContentType gender;
    private String nameTitle;
    private List<String> givenNameList = new ArrayList<String>();
    private List<String> middleNameList = new ArrayList<String>();
    private String surname;
    private String surnameSuffix;
    private String individualID;

    /** 
     * Get the 'Birthdate' element value. Individual's birth location (e.g. city and/or country).
     * 
     * @return value
     */
    public Date getBirthdate() {
        return birthdate;
    }

    /** 
     * Set the 'Birthdate' element value. Individual's birth location (e.g. city and/or country).
     * 
     * @param birthdate
     */
    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    /** 
     * Get the 'Birthplace' element value. Country Code where the Passenger was born (ISO 3166).  For example: DE
     * 
     * @return value
     */
    public String getBirthplace() {
        return birthplace;
    }

    /** 
     * Set the 'Birthplace' element value. Country Code where the Passenger was born (ISO 3166).  For example: DE
     * 
     * @param birthplace
     */
    public void setBirthplace(String birthplace) {
        this.birthplace = birthplace;
    }

    /** 
     * Get the 'Gender' element value. Gender of the individual (M, F, or X for unspecified).
     * 
     * @return value
     */
    public GenderCodeContentType getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. Gender of the individual (M, F, or X for unspecified).
     * 
     * @param gender
     */
    public void setGender(GenderCodeContentType gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'NameTitle' element value. Individual's name title. Examples: MR, MRS, DRn.
     * 
     * @return value
     */
    public String getNameTitle() {
        return nameTitle;
    }

    /** 
     * Set the 'NameTitle' element value. Individual's name title. Examples: MR, MRS, DRn.
     * 
     * @param nameTitle
     */
    public void setNameTitle(String nameTitle) {
        this.nameTitle = nameTitle;
    }

    /** 
     * Get the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
     * 
     * @return list
     */
    public List<String> getGivenNameList() {
        return givenNameList;
    }

    /** 
     * Set the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
     * 
     * @param list
     */
    public void setGivenNameList(List<String> list) {
        givenNameList = list;
    }

    /** 
     * Get the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
     * 
     * @return list
     */
    public List<String> getMiddleNameList() {
        return middleNameList;
    }

    /** 
     * Set the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
     * 
     * @param list
     */
    public void setMiddleNameList(List<String> list) {
        middleNameList = list;
    }

    /** 
     * Get the 'Surname' element value. Individual's family name, last name. Example: SMITH.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Individual's family name, last name. Example: SMITH.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'SurnameSuffix' element value. Individual's surname suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
     * 
     * @return value
     */
    public String getSurnameSuffix() {
        return surnameSuffix;
    }

    /** 
     * Set the 'SurnameSuffix' element value. Individual's surname suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
     * 
     * @param surnameSuffix
     */
    public void setSurnameSuffix(String surnameSuffix) {
        this.surnameSuffix = surnameSuffix;
    }

    /** 
     * Get the 'IndividualID' attribute value. Uniquely Identifies an Individual within the context of one message.
     * 
     * @return value
     */
    public String getIndividualID() {
        return individualID;
    }

    /** 
     * Set the 'IndividualID' attribute value. Uniquely Identifies an Individual within the context of one message.
     * 
     * @param individualID
     */
    public void setIndividualID(String individualID) {
        this.individualID = individualID;
    }
}
