
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Instructions: Class of Service Upgrade definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InstrClassUpgradeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Classes" minOccurs="0">
 *       &lt;!-- Reference to inner class Classes -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InstrClassUpgradeType implements Serializable
{
    private Classes classes;

    /** 
     * Get the 'Classes' element value.
     * 
     * @return value
     */
    public Classes getClasses() {
        return classes;
    }

    /** 
     * Set the 'Classes' element value.
     * 
     * @param classes
     */
    public void setClasses(Classes classes) {
        this.classes = classes;
    }
    /** 
     * Upgrade-eligible Service Class information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Classes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:ClassOfService" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Classes implements Serializable
    {
        private List<FlightCOSCoreType> classOfServiceList = new ArrayList<FlightCOSCoreType>();

        /** 
         * Get the list of 'ClassOfService' element items. Upgrade-eligible Class of Service. Example: T
         * 
         * @return list
         */
        public List<FlightCOSCoreType> getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the list of 'ClassOfService' element items. Upgrade-eligible Class of Service. Example: T
         * 
         * @param list
         */
        public void setClassOfServiceList(List<FlightCOSCoreType> list) {
            classOfServiceList = list;
        }
    }
}
