
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Response Message Processing.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvGuarResProcessType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="WarningInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InvGuarResProcessType extends AssociatedObjectBaseType implements
    Serializable
{
    private Remarks remarks;
    private Policies policies;
    private Boolean warningInd;

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'WarningInd' attribute value. When true, business warnings have been generated and the Notification/Warning node should be parsed.
     * 
     * @return value
     */
    public Boolean getWarningInd() {
        return warningInd;
    }

    /** 
     * Set the 'WarningInd' attribute value. When true, business warnings have been generated and the Notification/Warning node should be parsed.
     * 
     * @param warningInd
     */
    public void setWarningInd(Boolean warningInd) {
        this.warningInd = warningInd;
    }
}
