
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The InventoryGuarantee transaction set requests that inventory is guaranteed for specified Offers, pending their conversion into a completed Order.

 The response returns an indication if the inventory has been guaranteed, and if so, the associated inventory guarantee time limit and a unique inventory guarantee reference ID.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvGuaranteeRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *             &lt;xs:element ref="ns:ShoppingResponseID" minOccurs="0"/>
 *             &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
 *             &lt;xs:element ref="ns:OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
 *             &lt;xs:element name="OfferID" minOccurs="0"/>
 *             &lt;xs:element ref="ns:OfferItemID" minOccurs="0" maxOccurs="unbounded"/>
 *             &lt;xs:element name="Qualifiers" minOccurs="0">
 *               &lt;!-- Reference to inner class Qualifiers -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class InvGuaranteeRQ implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private BookingReferences queryBookingReferences;
    private ShoppingResponseIDType queryShoppingResponseID;
    private OrderIDType queryOrderID;
    private List<OrderItemID> queryOrderItemIDList = new ArrayList<OrderItemID>();
    private boolean queryOfferID;
    private List<OfferItemID> queryOfferItemIDList = new ArrayList<OfferItemID>();
    private Qualifiers qualifiers;
    private DataLists dataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getQueryShoppingResponseID() {
        return queryShoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param queryShoppingResponseID
     */
    public void setQueryShoppingResponseID(
            ShoppingResponseIDType queryShoppingResponseID) {
        this.queryShoppingResponseID = queryShoppingResponseID;
    }

    /** 
     * Get the 'OrderID' element value. Order ID. Example: ORDER7333
     * 
     * @return value
     */
    public OrderIDType getQueryOrderID() {
        return queryOrderID;
    }

    /** 
     * Set the 'OrderID' element value. Order ID. Example: ORDER7333
     * 
     * @param queryOrderID
     */
    public void setQueryOrderID(OrderIDType queryOrderID) {
        this.queryOrderID = queryOrderID;
    }

    /** 
     * Get the list of 'OrderItemID' element items. Order Item ID(s). Example: ORD7333-001
     * 
     * @return list
     */
    public List<OrderItemID> getQueryOrderItemIDList() {
        return queryOrderItemIDList;
    }

    /** 
     * Set the list of 'OrderItemID' element items. Order Item ID(s). Example: ORD7333-001
     * 
     * @param list
     */
    public void setQueryOrderItemIDList(List<OrderItemID> list) {
        queryOrderItemIDList = list;
    }

    /** 
     * Check if the 'OfferID' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifQueryOfferIDPresent() {
        return queryOfferID;
    }

    /** 
     * Set flag for 'OfferID' element present.
     * 
     * @param queryOfferID
     */
    public void flagQueryOfferIDPresent(boolean queryOfferID) {
        this.queryOfferID = queryOfferID;
    }

    /** 
     * Get the list of 'OfferItemID' element items. Offer Item ID(s). Example: OFFER1226
     * 
     * @return list
     */
    public List<OfferItemID> getQueryOfferItemIDList() {
        return queryOfferItemIDList;
    }

    /** 
     * Set the list of 'OfferItemID' element items. Offer Item ID(s). Example: OFFER1226
     * 
     * @param list
     */
    public void setQueryOfferItemIDList(List<OfferItemID> list) {
        queryOfferItemIDList = list;
    }

    /** 
     * Get the 'Qualifiers' element value. Inventory Guarantee Query.
     * 
     * @return value
     */
    public Qualifiers getQualifiers() {
        return qualifiers;
    }

    /** 
     * Set the 'Qualifiers' element value. Inventory Guarantee Query.
     * 
     * @param qualifiers
     */
    public void setQualifiers(Qualifiers qualifiers) {
        this.qualifiers = qualifiers;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Qualifiers to influence inventory guarantee request processing.

    Note: These capabilities may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PaymentCards" minOccurs="0">
     *         &lt;!-- Reference to inner class PaymentCards -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Programs" minOccurs="0">
     *         &lt;!-- Reference to inner class Programs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Promotions" minOccurs="0">
     *         &lt;!-- Reference to inner class Promotions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Seat" minOccurs="0">
     *         &lt;!-- Reference to inner class Seat -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:SocialMediaQualifierType" name="SocialMedia" minOccurs="0"/>
     *       &lt;xs:element name="SpecialNeeds" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialNeeds -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:TripPurposeListType" name="TripPurpose" minOccurs="0"/>
     *       &lt;xs:element name="Locations" minOccurs="0">
     *         &lt;!-- Reference to inner class Locations -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Qualifiers implements Serializable
    {
        private PaymentCards paymentCards;
        private Programs programs;
        private Promotions promotions;
        private Seat seat;
        private SocialMediaQualifierType socialMedia;
        private SpecialNeeds specialNeeds;
        private TripPurposeListType tripPurpose;
        private Locations locations;

        /** 
         * Get the 'PaymentCards' element value.
         * 
         * @return value
         */
        public PaymentCards getPaymentCards() {
            return paymentCards;
        }

        /** 
         * Set the 'PaymentCards' element value.
         * 
         * @param paymentCards
         */
        public void setPaymentCards(PaymentCards paymentCards) {
            this.paymentCards = paymentCards;
        }

        /** 
         * Get the 'Programs' element value.
         * 
         * @return value
         */
        public Programs getPrograms() {
            return programs;
        }

        /** 
         * Set the 'Programs' element value.
         * 
         * @param programs
         */
        public void setPrograms(Programs programs) {
            this.programs = programs;
        }

        /** 
         * Get the 'Promotions' element value.
         * 
         * @return value
         */
        public Promotions getPromotions() {
            return promotions;
        }

        /** 
         * Set the 'Promotions' element value.
         * 
         * @param promotions
         */
        public void setPromotions(Promotions promotions) {
            this.promotions = promotions;
        }

        /** 
         * Get the 'Seat' element value.
         * 
         * @return value
         */
        public Seat getSeat() {
            return seat;
        }

        /** 
         * Set the 'Seat' element value.
         * 
         * @param seat
         */
        public void setSeat(Seat seat) {
            this.seat = seat;
        }

        /** 
         * Get the 'SocialMedia' element value. Social Media Account Qualifier.
         * 
         * @return value
         */
        public SocialMediaQualifierType getSocialMedia() {
            return socialMedia;
        }

        /** 
         * Set the 'SocialMedia' element value. Social Media Account Qualifier.
         * 
         * @param socialMedia
         */
        public void setSocialMedia(SocialMediaQualifierType socialMedia) {
            this.socialMedia = socialMedia;
        }

        /** 
         * Get the 'SpecialNeeds' element value.
         * 
         * @return value
         */
        public SpecialNeeds getSpecialNeeds() {
            return specialNeeds;
        }

        /** 
         * Set the 'SpecialNeeds' element value.
         * 
         * @param specialNeeds
         */
        public void setSpecialNeeds(SpecialNeeds specialNeeds) {
            this.specialNeeds = specialNeeds;
        }

        /** 
         * Get the 'TripPurpose' element value. TRIP PURPOSE Qualifier.
         * 
         * @return value
         */
        public TripPurposeListType getTripPurpose() {
            return tripPurpose;
        }

        /** 
         * Set the 'TripPurpose' element value. TRIP PURPOSE Qualifier.
         * 
         * @param tripPurpose
         */
        public void setTripPurpose(TripPurposeListType tripPurpose) {
            this.tripPurpose = tripPurpose;
        }

        /** 
         * Get the 'Locations' element value.
         * 
         * @return value
         */
        public Locations getLocations() {
            return locations;
        }

        /** 
         * Set the 'Locations' element value.
         * 
         * @param locations
         */
        public void setLocations(Locations locations) {
            this.locations = locations;
        }
        /** 
         * PAYMENT CARD Qualifier(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCards" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CardQualifierType" name="PaymentCard" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaymentCards implements Serializable
        {
            private List<CardQualifierType> paymentCardList = new ArrayList<CardQualifierType>();

            /** 
             * Get the list of 'PaymentCard' element items. Payment Card.
             * 
             * @return list
             */
            public List<CardQualifierType> getPaymentCardList() {
                return paymentCardList;
            }

            /** 
             * Set the list of 'PaymentCard' element items. Payment Card.
             * 
             * @param list
             */
            public void setPaymentCardList(List<CardQualifierType> list) {
                paymentCardList = list;
            }
        }
        /** 
         * PROGRAM Qualifier(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Programs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ProgramQualifierType" name="Program" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Programs implements Serializable
        {
            private List<ProgramQualifierType> programList = new ArrayList<ProgramQualifierType>();

            /** 
             * Get the list of 'Program' element items. Program Qualifier detail.
             * 
             * @return list
             */
            public List<ProgramQualifierType> getProgramList() {
                return programList;
            }

            /** 
             * Set the list of 'Program' element items. Program Qualifier detail.
             * 
             * @param list
             */
            public void setProgramList(List<ProgramQualifierType> list) {
                programList = list;
            }
        }
        /** 
         * PROMOTION Qualifier(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PromotionType" name="Promotion" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotions implements Serializable
        {
            private List<PromotionType> promotionList = new ArrayList<PromotionType>();

            /** 
             * Get the list of 'Promotion' element items. Promotion(s) Information.
             * 
             * @return list
             */
            public List<PromotionType> getPromotionList() {
                return promotionList;
            }

            /** 
             * Set the list of 'Promotion' element items. Promotion(s) Information.
             * 
             * @param list
             */
            public void setPromotionList(List<PromotionType> list) {
                promotionList = list;
            }
        }
        /** 
         * SEAT Qualifier(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:SeatCoreType" name="Assignment" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Seat implements Serializable
        {
            private List<SeatCoreType> assignmentList = new ArrayList<SeatCoreType>();

            /** 
             * Get the list of 'Assignment' element items. Seat assignment information.
             * 
             * @return list
             */
            public List<SeatCoreType> getAssignmentList() {
                return assignmentList;
            }

            /** 
             * Set the list of 'Assignment' element items. Seat assignment information.
             * 
             * @param list
             */
            public void setAssignmentList(List<SeatCoreType> list) {
                assignmentList = list;
            }
        }
        /** 
         * SPECIAL NEED Qualifier(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialNeeds" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:SpecialType" name="SpecialNeed" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialNeeds implements Serializable
        {
            private List<SpecialType> specialNeedList = new ArrayList<SpecialType>();

            /** 
             * Get the list of 'SpecialNeed' element items. Passenger Special Needs Attributes.
             * 
             * @return list
             */
            public List<SpecialType> getSpecialNeedList() {
                return specialNeedList;
            }

            /** 
             * Set the list of 'SpecialNeed' element items. Passenger Special Needs Attributes.
             * 
             * @param list
             */
            public void setSpecialNeedList(List<SpecialType> list) {
                specialNeedList = list;
            }
        }
        /** 
         * Trip Flight Location information.

        Note: This information may be used for airport associated products, such as an annual lounge pass.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Locations" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="xs:string" name="LocationCode" maxOccurs="unbounded"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Locations extends AssociatedObjectBaseType
            implements Serializable
        {
            private List<String> locationCodeList = new ArrayList<String>();

            /** 
             * Get the list of 'LocationCode' element items. Airport or City Location code. Example: TPA

            Encoding Scheme: IATA/ A4A (three character) Airport or City Code
             * 
             * @return list
             */
            public List<String> getLocationCodeList() {
                return locationCodeList;
            }

            /** 
             * Set the list of 'LocationCode' element items. Airport or City Location code. Example: TPA

            Encoding Scheme: IATA/ A4A (three character) Airport or City Code
             * 
             * @param list
             */
            public void setLocationCodeList(List<String> list) {
                locationCodeList = list;
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="PassengerList" minOccurs="0">
     *             &lt;!-- Reference to inner class PassengerList -->
     *           &lt;/xs:element>
     *           &lt;xs:element name="ContactList" minOccurs="0">
     *             &lt;!-- Reference to inner class ContactList -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists extends DataListType implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
