
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The InventoryGuarantee transaction set requests that inventory is guaranteed for specified Offers, pending their conversion into a completed Order.

 The response returns an indication if the inventory has been guaranteed, and if so, the associated inventory guarantee time limit and a unique inventory guarantee reference ID.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvGuaranteeRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:InvGuaranteeProcessing" minOccurs="0"/>
 *                 &lt;xs:element name="Guarantees" minOccurs="0">
 *                   &lt;!-- Reference to inner class Guarantees -->
 *                 &lt;/xs:element>
 *               &lt;/xs:sequence>
 *               &lt;xs:attribute type="xs:boolean" use="optional" name="NoGuaranteeInd"/>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *           &lt;xs:element name="DataLists" minOccurs="0">
 *             &lt;!-- Reference to inner class DataLists -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Metadata" minOccurs="0">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:CurrencyMetadatas"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class InvGuaranteeRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private InvGuarResProcessType responseInvGuaranteeProcessing;
    private Guarantees guarantees;
    private Boolean responseNoGuaranteeInd;
    private DataLists dataLists;
    private CurrencyMetadatas metadata;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'InvGuaranteeProcessing' element value. Transaction Processing Results, including processing status, business warnings, supplemental marketing messages and/ or additional information required to complete a transaction.
     * 
     * @return value
     */
    public InvGuarResProcessType getResponseInvGuaranteeProcessing() {
        return responseInvGuaranteeProcessing;
    }

    /** 
     * Set the 'InvGuaranteeProcessing' element value. Transaction Processing Results, including processing status, business warnings, supplemental marketing messages and/ or additional information required to complete a transaction.
     * 
     * @param responseInvGuaranteeProcessing
     */
    public void setResponseInvGuaranteeProcessing(
            InvGuarResProcessType responseInvGuaranteeProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseInvGuaranteeProcessing = responseInvGuaranteeProcessing;
    }

    /** 
     * Get the 'Guarantees' element value. Query Results.
     * 
     * @return value
     */
    public Guarantees getGuarantees() {
        return guarantees;
    }

    /** 
     * Set the 'Guarantees' element value. Query Results.
     * 
     * @param guarantees
     */
    public void setGuarantees(Guarantees guarantees) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.guarantees = guarantees;
    }

    /** 
     * Get the 'NoGuaranteeInd' attribute value. When true, no inventory could be guaranteed.
     * 
     * @return value
     */
    public Boolean getResponseNoGuaranteeInd() {
        return responseNoGuaranteeInd;
    }

    /** 
     * Set the 'NoGuaranteeInd' attribute value. When true, no inventory could be guaranteed.
     * 
     * @param responseNoGuaranteeInd
     */
    public void setResponseNoGuaranteeInd(Boolean responseNoGuaranteeInd) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseNoGuaranteeInd = responseNoGuaranteeInd;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'CurrencyMetadatas' element value. Metadata List(s).
     * 
     * @return value
     */
    public CurrencyMetadatas getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'CurrencyMetadatas' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(CurrencyMetadatas metadata) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Guaranteed Inventory information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Guarantee" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Guarantee -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Guarantees implements Serializable
    {
        private List<Guarantee> guaranteeList = new ArrayList<Guarantee>();

        /** 
         * Get the list of 'Guarantee' element items.
         * 
         * @return list
         */
        public List<Guarantee> getGuaranteeList() {
            return guaranteeList;
        }

        /** 
         * Set the list of 'Guarantee' element items.
         * 
         * @param list
         */
        public void setGuaranteeList(List<Guarantee> list) {
            guaranteeList = list;
        }
        /** 
         * Guaranteed Inventory Item detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantee" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
         *       &lt;xs:element ref="ns:InventoryGuaranteeTimeLimits"/>
         *       &lt;xs:element name="Associations" minOccurs="0">
         *         &lt;!-- Reference to inner class Associations -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Price" minOccurs="0">
         *         &lt;!-- Reference to inner class Price -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:ShoppingResponseID"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="WaitlistInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Guarantee implements Serializable
        {
            private String invGuaranteeID;
            private CoreDateGrpType inventoryGuaranteeTimeLimits;
            private Associations associations;
            private Price price;
            private ShoppingResponseIDType shoppingResponseID;
            private Boolean waitlistInd;

            /** 
             * Get the 'InvGuaranteeID' element value. Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C

            Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
             * 
             * @return value
             */
            public String getInvGuaranteeID() {
                return invGuaranteeID;
            }

            /** 
             * Set the 'InvGuaranteeID' element value. Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C

            Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
             * 
             * @param invGuaranteeID
             */
            public void setInvGuaranteeID(String invGuaranteeID) {
                this.invGuaranteeID = invGuaranteeID;
            }

            /** 
             * Get the 'InventoryGuaranteeTimeLimits' element value.
             * 
             * @return value
             */
            public CoreDateGrpType getInventoryGuaranteeTimeLimits() {
                return inventoryGuaranteeTimeLimits;
            }

            /** 
             * Set the 'InventoryGuaranteeTimeLimits' element value.
             * 
             * @param inventoryGuaranteeTimeLimits
             */
            public void setInventoryGuaranteeTimeLimits(
                    CoreDateGrpType inventoryGuaranteeTimeLimits) {
                this.inventoryGuaranteeTimeLimits = inventoryGuaranteeTimeLimits;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'Price' element value.
             * 
             * @return value
             */
            public Price getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value.
             * 
             * @param price
             */
            public void setPrice(Price price) {
                this.price = price;
            }

            /** 
             * Get the 'ShoppingResponseID' element value.
             * 
             * @return value
             */
            public ShoppingResponseIDType getShoppingResponseID() {
                return shoppingResponseID;
            }

            /** 
             * Set the 'ShoppingResponseID' element value.
             * 
             * @param shoppingResponseID
             */
            public void setShoppingResponseID(
                    ShoppingResponseIDType shoppingResponseID) {
                this.shoppingResponseID = shoppingResponseID;
            }

            /** 
             * Get the 'WaitlistInd' attribute value. When true, the inventory is waitlisted.
             * 
             * @return value
             */
            public Boolean getWaitlistInd() {
                return waitlistInd;
            }

            /** 
             * Set the 'WaitlistInd' attribute value. When true, the inventory is waitlisted.
             * 
             * @param waitlistInd
             */
            public void setWaitlistInd(Boolean waitlistInd) {
                this.waitlistInd = waitlistInd;
            }
            /** 
             * Guaranteed Inventory associations.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OrderItemID" minOccurs="0"/>
             *       &lt;xs:element name="OtherAssociation" minOccurs="0">
             *         &lt;!-- Reference to inner class OtherAssociation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Associations implements Serializable
            {
                private ServiceIDType serviceID;
                private OfferItemID offerItemID;
                private OrderIDType orderID;
                private OrderItemID orderItemID;
                private OtherAssociation otherAssociation;

                /** 
                 * Get the 'ServiceID' element value. Associated Service ID(s). Example: SRVC0001
                 * 
                 * @return value
                 */
                public ServiceIDType getServiceID() {
                    return serviceID;
                }

                /** 
                 * Set the 'ServiceID' element value. Associated Service ID(s). Example: SRVC0001
                 * 
                 * @param serviceID
                 */
                public void setServiceID(ServiceIDType serviceID) {
                    this.serviceID = serviceID;
                }

                /** 
                 * Get the 'OfferItemID' element value. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @return value
                 */
                public OfferItemID getOfferItemID() {
                    return offerItemID;
                }

                /** 
                 * Set the 'OfferItemID' element value. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @param offerItemID
                 */
                public void setOfferItemID(OfferItemID offerItemID) {
                    this.offerItemID = offerItemID;
                }

                /** 
                 * Get the 'OrderID' element value. Associated Order ID
                Example: ORDER7333
                 * 
                 * @return value
                 */
                public OrderIDType getOrderID() {
                    return orderID;
                }

                /** 
                 * Set the 'OrderID' element value. Associated Order ID
                Example: ORDER7333
                 * 
                 * @param orderID
                 */
                public void setOrderID(OrderIDType orderID) {
                    this.orderID = orderID;
                }

                /** 
                 * Get the 'OrderItemID' element value. Associated Order Item ID(s).
                Example: ORD7333-001
                 * 
                 * @return value
                 */
                public OrderItemID getOrderItemID() {
                    return orderItemID;
                }

                /** 
                 * Set the 'OrderItemID' element value. Associated Order Item ID(s).
                Example: ORD7333-001
                 * 
                 * @param orderItemID
                 */
                public void setOrderItemID(OrderItemID orderItemID) {
                    this.orderItemID = orderItemID;
                }

                /** 
                 * Get the 'OtherAssociation' element value.
                 * 
                 * @return value
                 */
                public OtherAssociation getOtherAssociation() {
                    return otherAssociation;
                }

                /** 
                 * Set the 'OtherAssociation' element value.
                 * 
                 * @param otherAssociation
                 */
                public void setOtherAssociation(
                        OtherAssociation otherAssociation) {
                    this.otherAssociation = otherAssociation;
                }
                /** 
                 * Other Named Association(s).

                Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherAssociation implements Serializable
                {
                    private String type;
                    private String referenceValue;

                    /** 
                     * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @return value
                     */
                    public String getReferenceValue() {
                        return referenceValue;
                    }

                    /** 
                     * Set the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @param referenceValue
                     */
                    public void setReferenceValue(String referenceValue) {
                        this.referenceValue = referenceValue;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:PriceCoreType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Price extends PriceCoreType implements
                Serializable
            {
                private CurrencyAmountOptType amount;

                /** 
                 * Get the 'Amount' element value.
                 * 
                 * @return value
                 */
                public CurrencyAmountOptType getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value.
                 * 
                 * @param amount
                 */
                public void setAmount(CurrencyAmountOptType amount) {
                    this.amount = amount;
                }
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="PassengerList" minOccurs="0">
     *             &lt;!-- Reference to inner class PassengerList -->
     *           &lt;/xs:element>
     *           &lt;xs:element name="ContactList" minOccurs="0">
     *             &lt;!-- Reference to inner class ContactList -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists extends DataListType implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
