
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Offer/ Offer Item: INVENTORY GUARANTEE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvGuaranteeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CoreDateGrpType" name="InvGuaranteeTimeLimit"/>
 *     &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
 *     &lt;xs:element ref="ns:OfferReferences" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class InvGuaranteeType implements Serializable
{
    private CoreDateGrpType invGuaranteeTimeLimit;
    private String invGuaranteeID;
    private OfferReferences offerReferences;
    private String refs;

    /** 
     * Get the 'InvGuaranteeTimeLimit' element value. Time limit by which guaranteed inventory for a specified product offer is guaranteed as available and by which the inventory held must be converted into a completed order before the time limit expires otherwise the guarantee is lost.

    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public CoreDateGrpType getInvGuaranteeTimeLimit() {
        return invGuaranteeTimeLimit;
    }

    /** 
     * Set the 'InvGuaranteeTimeLimit' element value. Time limit by which guaranteed inventory for a specified product offer is guaranteed as available and by which the inventory held must be converted into a completed order before the time limit expires otherwise the guarantee is lost.

    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z
     * 
     * @param invGuaranteeTimeLimit
     */
    public void setInvGuaranteeTimeLimit(CoreDateGrpType invGuaranteeTimeLimit) {
        this.invGuaranteeTimeLimit = invGuaranteeTimeLimit;
    }

    /** 
     * Get the 'InvGuaranteeID' element value. Unique Inventory Guarantee ID.
    Examples: INVREF123456, 68E0DB2F-675C-44F7-BC1E-653106099FF9

    Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
     * 
     * @return value
     */
    public String getInvGuaranteeID() {
        return invGuaranteeID;
    }

    /** 
     * Set the 'InvGuaranteeID' element value. Unique Inventory Guarantee ID.
    Examples: INVREF123456, 68E0DB2F-675C-44F7-BC1E-653106099FF9

    Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
     * 
     * @param invGuaranteeID
     */
    public void setInvGuaranteeID(String invGuaranteeID) {
        this.invGuaranteeID = invGuaranteeID;
    }

    /** 
     * Get the 'OfferReferences' element value. Association(s) to one or more Offers or Offer Items for which the inventory guarantee applies.
     * 
     * @return value
     */
    public OfferReferences getOfferReferences() {
        return offerReferences;
    }

    /** 
     * Set the 'OfferReferences' element value. Association(s) to one or more Offers or Offer Items for which the inventory guarantee applies.
     * 
     * @param offerReferences
     */
    public void setOfferReferences(OfferReferences offerReferences) {
        this.offerReferences = offerReferences;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
