
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The InventoryRelease transaction sends an unsolicited notification to release guaranteed inventory.

 The Acknowledgement message may be returned to acknowledge receipt of the notification request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvReleaseNotif">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Guarantee" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class Guarantee -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class InvReleaseNotif implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private List<Guarantee> queryList = new ArrayList<Guarantee>();
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the list of 'Guarantee' element items. Inventory Release Notification.
     * 
     * @return list
     */
    public List<Guarantee> getQueryList() {
        return queryList;
    }

    /** 
     * Set the list of 'Guarantee' element items. Inventory Release Notification.
     * 
     * @param list
     */
    public void setQueryList(List<Guarantee> list) {
        queryList = list;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Previously guaranteed inventory to release.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantee" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
     *       &lt;xs:element ref="ns:InventoryGuaranteeTimeLimits" minOccurs="0"/>
     *       &lt;xs:element name="Association" minOccurs="0">
     *         &lt;!-- Reference to inner class Association -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="WaitlistedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Guarantee implements Serializable
    {
        private String invGuaranteeID;
        private CoreDateGrpType inventoryGuaranteeTimeLimits;
        private Association association;
        private Boolean waitlistedInd;

        /** 
         * Get the 'InvGuaranteeID' element value. Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C

        Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
         * 
         * @return value
         */
        public String getInvGuaranteeID() {
            return invGuaranteeID;
        }

        /** 
         * Set the 'InvGuaranteeID' element value. Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C

        Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
         * 
         * @param invGuaranteeID
         */
        public void setInvGuaranteeID(String invGuaranteeID) {
            this.invGuaranteeID = invGuaranteeID;
        }

        /** 
         * Get the 'InventoryGuaranteeTimeLimits' element value.
         * 
         * @return value
         */
        public CoreDateGrpType getInventoryGuaranteeTimeLimits() {
            return inventoryGuaranteeTimeLimits;
        }

        /** 
         * Set the 'InventoryGuaranteeTimeLimits' element value.
         * 
         * @param inventoryGuaranteeTimeLimits
         */
        public void setInventoryGuaranteeTimeLimits(
                CoreDateGrpType inventoryGuaranteeTimeLimits) {
            this.inventoryGuaranteeTimeLimits = inventoryGuaranteeTimeLimits;
        }

        /** 
         * Get the 'Association' element value.
         * 
         * @return value
         */
        public Association getAssociation() {
            return association;
        }

        /** 
         * Set the 'Association' element value.
         * 
         * @param association
         */
        public void setAssociation(Association association) {
            this.association = association;
        }

        /** 
         * Get the 'WaitlistedInd' attribute value. When true, the inventory was waitlisted.
         * 
         * @return value
         */
        public Boolean getWaitlistedInd() {
            return waitlistedInd;
        }

        /** 
         * Set the 'WaitlistedInd' attribute value. When true, the inventory was waitlisted.
         * 
         * @param waitlistedInd
         */
        public void setWaitlistedInd(Boolean waitlistedInd) {
            this.waitlistedInd = waitlistedInd;
        }
        /** 
         * Guaranteed Inventory detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Association" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OrderItemID" minOccurs="0"/>
         *       &lt;xs:element name="OtherAssociation" minOccurs="0">
         *         &lt;!-- Reference to inner class OtherAssociation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Association implements Serializable
        {
            private ServiceIDType serviceID;
            private OfferItemID offerItemID;
            private OrderIDType orderID;
            private OrderItemID orderItemID;
            private OtherAssociation otherAssociation;

            /** 
             * Get the 'ServiceID' element value. Associated Service ID(s). Example: SRVC0001
             * 
             * @return value
             */
            public ServiceIDType getServiceID() {
                return serviceID;
            }

            /** 
             * Set the 'ServiceID' element value. Associated Service ID(s). Example: SRVC0001
             * 
             * @param serviceID
             */
            public void setServiceID(ServiceIDType serviceID) {
                this.serviceID = serviceID;
            }

            /** 
             * Get the 'OfferItemID' element value. Associated Offer Item ID(s).
            Example: OFFER1226
             * 
             * @return value
             */
            public OfferItemID getOfferItemID() {
                return offerItemID;
            }

            /** 
             * Set the 'OfferItemID' element value. Associated Offer Item ID(s).
            Example: OFFER1226
             * 
             * @param offerItemID
             */
            public void setOfferItemID(OfferItemID offerItemID) {
                this.offerItemID = offerItemID;
            }

            /** 
             * Get the 'OrderID' element value. Associated Order ID
            Example: ORDER7333
             * 
             * @return value
             */
            public OrderIDType getOrderID() {
                return orderID;
            }

            /** 
             * Set the 'OrderID' element value. Associated Order ID
            Example: ORDER7333
             * 
             * @param orderID
             */
            public void setOrderID(OrderIDType orderID) {
                this.orderID = orderID;
            }

            /** 
             * Get the 'OrderItemID' element value. Associated Order Item ID(s).
            Example: ORD7333-001
             * 
             * @return value
             */
            public OrderItemID getOrderItemID() {
                return orderItemID;
            }

            /** 
             * Set the 'OrderItemID' element value. Associated Order Item ID(s).
            Example: ORD7333-001
             * 
             * @param orderItemID
             */
            public void setOrderItemID(OrderItemID orderItemID) {
                this.orderItemID = orderItemID;
            }

            /** 
             * Get the 'OtherAssociation' element value.
             * 
             * @return value
             */
            public OtherAssociation getOtherAssociation() {
                return otherAssociation;
            }

            /** 
             * Set the 'OtherAssociation' element value.
             * 
             * @param otherAssociation
             */
            public void setOtherAssociation(OtherAssociation otherAssociation) {
                this.otherAssociation = otherAssociation;
            }
            /** 
             * Other Named Association(s).

            Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OtherAssociation implements Serializable
            {
                private String type;
                private String referenceValue;

                /** 
                 * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'ReferenceValue' attribute value. Associated object instance value.
                Example: mediagrp1
                 * 
                 * @return value
                 */
                public String getReferenceValue() {
                    return referenceValue;
                }

                /** 
                 * Set the 'ReferenceValue' attribute value. Associated object instance value.
                Example: mediagrp1
                 * 
                 * @param referenceValue
                 */
                public void setReferenceValue(String referenceValue) {
                    this.referenceValue = referenceValue;
                }
            }
        }
    }
}
