
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Request Message Parameters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinReshopParamsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Alerts" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:PinPhraseAnswerType" name="PIN_AuthAlertResponse" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Notices" minOccurs="0">
 *       &lt;!-- Reference to inner class Notices -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CurrCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class CurrCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Reason" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItinReshopParamsType implements Serializable
{
    private PinPhraseAnswerType alerts;
    private Notices notices;
    private CurrCodes currCodes;
    private String reason;
    private String refs;

    /** 
     * Get the 'PIN_AuthAlertResponse' element value. Traveler PIN Phrase Authentication Response.

    Notes:
    1. This is part of an ongoing transaction for a processing condition that occured when additional Traveler authentication was required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme response information, e.g. the Pin Phrase answer.
     * 
     * @return value
     */
    public PinPhraseAnswerType getAlerts() {
        return alerts;
    }

    /** 
     * Set the 'PIN_AuthAlertResponse' element value. Traveler PIN Phrase Authentication Response.

    Notes:
    1. This is part of an ongoing transaction for a processing condition that occured when additional Traveler authentication was required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme response information, e.g. the Pin Phrase answer.
     * 
     * @param alerts
     */
    public void setAlerts(PinPhraseAnswerType alerts) {
        this.alerts = alerts;
    }

    /** 
     * Get the 'Notices' element value.
     * 
     * @return value
     */
    public Notices getNotices() {
        return notices;
    }

    /** 
     * Set the 'Notices' element value.
     * 
     * @param notices
     */
    public void setNotices(Notices notices) {
        this.notices = notices;
    }

    /** 
     * Get the 'CurrCodes' element value.
     * 
     * @return value
     */
    public CurrCodes getCurrCodes() {
        return currCodes;
    }

    /** 
     * Set the 'CurrCodes' element value.
     * 
     * @param currCodes
     */
    public void setCurrCodes(CurrCodes currCodes) {
        this.currCodes = currCodes;
    }

    /** 
     * Get the 'Reason' element value. Reason for change. 

    Encoding Scheme: IATA Padis Codeset REA
     * 
     * @return value
     */
    public String getReason() {
        return reason;
    }

    /** 
     * Set the 'Reason' element value. Reason for change. 

    Encoding Scheme: IATA Padis Codeset REA
     * 
     * @param reason
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Transaction Processing Notice(s).

    Note: These notices contain requested transaction processing parameters that may be ignored by EDIST-enabled systems that do not support the capability.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Notices" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:NoticeBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="PricingParameters" minOccurs="0">
     *             &lt;!-- Reference to inner class PricingParameters -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Notices extends NoticeBaseType implements Serializable
    {
        private PricingParameters pricingParameters;

        /** 
         * Get the 'PricingParameters' element value.
         * 
         * @return value
         */
        public PricingParameters getPricingParameters() {
            return pricingParameters;
        }

        /** 
         * Set the 'PricingParameters' element value.
         * 
         * @param pricingParameters
         */
        public void setPricingParameters(PricingParameters pricingParameters) {
            this.pricingParameters = pricingParameters;
        }
        /** 
         * Pricing Parameters Notice.

        Note: Supports specifying transaction pricing parameters. Request messages may include indicators requesting that certain methods be applied during payment processing where relevant. Response messages may additionally include notice about if and how pricing parameters were applied during transaction processing.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingParameters" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchRequestInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="IncludeAwardRequestInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardOnlyRequestInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="SimpleRequestInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingParameters implements Serializable
        {
            private Boolean autoExchRequestInd;
            private Boolean includeAwardRequestInd;
            private Boolean awardOnlyRequestInd;
            private Boolean simpleRequestInd;

            /** 
             * Get the 'AutoExchRequestInd' attribute value. When true, this request is to be handled by an auto-exchange process.
             * 
             * @return value
             */
            public Boolean getAutoExchRequestInd() {
                return autoExchRequestInd;
            }

            /** 
             * Set the 'AutoExchRequestInd' attribute value. When true, this request is to be handled by an auto-exchange process.
             * 
             * @param autoExchRequestInd
             */
            public void setAutoExchRequestInd(Boolean autoExchRequestInd) {
                this.autoExchRequestInd = autoExchRequestInd;
            }

            /** 
             * Get the 'IncludeAwardRequestInd' attribute value. When true, award eligible in addition to priced offers and fares is requested.
             * 
             * @return value
             */
            public Boolean getIncludeAwardRequestInd() {
                return includeAwardRequestInd;
            }

            /** 
             * Set the 'IncludeAwardRequestInd' attribute value. When true, award eligible in addition to priced offers and fares is requested.
             * 
             * @param includeAwardRequestInd
             */
            public void setIncludeAwardRequestInd(Boolean includeAwardRequestInd) {
                this.includeAwardRequestInd = includeAwardRequestInd;
            }

            /** 
             * Get the 'AwardOnlyRequestInd' attribute value. When true, only award eligible offers/ fares are requested.
             * 
             * @return value
             */
            public Boolean getAwardOnlyRequestInd() {
                return awardOnlyRequestInd;
            }

            /** 
             * Set the 'AwardOnlyRequestInd' attribute value. When true, only award eligible offers/ fares are requested.
             * 
             * @param awardOnlyRequestInd
             */
            public void setAwardOnlyRequestInd(Boolean awardOnlyRequestInd) {
                this.awardOnlyRequestInd = awardOnlyRequestInd;
            }

            /** 
             * Get the 'SimpleRequestInd' attribute value. When true, Simple Pricing  for flight offers is requested.
             * 
             * @return value
             */
            public Boolean getSimpleRequestInd() {
                return simpleRequestInd;
            }

            /** 
             * Set the 'SimpleRequestInd' attribute value. When true, Simple Pricing  for flight offers is requested.
             * 
             * @param simpleRequestInd
             */
            public void setSimpleRequestInd(Boolean simpleRequestInd) {
                this.simpleRequestInd = simpleRequestInd;
            }
        }
    }
    /** 
     * Requested search processing and results currency information.

    Notes:
    1. Currency context is specified in the @application attribute, e.g. Requested, Display.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:CurrCode" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CurrCodes implements Serializable
    {
        private List<CurrCode> currCodeList = new ArrayList<CurrCode>();

        /** 
         * Get the list of 'CurrCode' element items.
         * 
         * @return list
         */
        public List<CurrCode> getCurrCodeList() {
            return currCodeList;
        }

        /** 
         * Set the list of 'CurrCode' element items.
         * 
         * @param list
         */
        public void setCurrCodeList(List<CurrCode> list) {
            currCodeList = list;
        }
    }
}
