
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" mixed="true" name="KeyInfoType">
 *   &lt;xs:choice maxOccurs="unbounded">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class KeyInfoType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();
    private String id;

    /** 
     * Get the list of choice items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of choice items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element ref="KeyName"/>
     *   &lt;xs:element ref="KeyValue"/>
     *   &lt;xs:element ref="RetrievalMethod"/>
     *   &lt;xs:element ref="X509Data"/>
     *   &lt;xs:element ref="PGPData"/>
     *   &lt;xs:element ref="SPKIData"/>
     *   &lt;xs:element ref="MgmtData"/>
     *   &lt;xs:any processContents="lax" namespace="##other"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int KEY_NAME_CHOICE = 0;
        private static final int KEY_VALUE_CHOICE = 1;
        private static final int RETRIEVAL_METHOD_CHOICE = 2;
        private static final int X509_DATA_CHOICE = 3;
        private static final int PGP_DATA_CHOICE = 4;
        private static final int SPKI_DATA_CHOICE = 5;
        private static final int MGMT_DATA_CHOICE = 6;
        private static final int ANY_CHOICE = 7;
        private KeyName keyName;
        private KeyValueType keyValue;
        private RetrievalMethodType retrievalMethod;
        private X509DataType x509Data;
        private PGPDataType PGPData;
        private SPKIDataType SPKIData;
        private MgmtData mgmtData;
        private Element any;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if KeyName is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifKeyName() {
            return choiceListSelect == KEY_NAME_CHOICE;
        }

        /** 
         * Get the 'KeyName' element value.
         * 
         * @return value
         */
        public KeyName getKeyName() {
            return keyName;
        }

        /** 
         * Set the 'KeyName' element value.
         * 
         * @param keyName
         */
        public void setKeyName(KeyName keyName) {
            setChoiceListSelect(KEY_NAME_CHOICE);
            this.keyName = keyName;
        }

        /** 
         * Check if KeyValue is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifKeyValue() {
            return choiceListSelect == KEY_VALUE_CHOICE;
        }

        /** 
         * Get the 'KeyValue' element value.
         * 
         * @return value
         */
        public KeyValueType getKeyValue() {
            return keyValue;
        }

        /** 
         * Set the 'KeyValue' element value.
         * 
         * @param keyValue
         */
        public void setKeyValue(KeyValueType keyValue) {
            setChoiceListSelect(KEY_VALUE_CHOICE);
            this.keyValue = keyValue;
        }

        /** 
         * Check if RetrievalMethod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRetrievalMethod() {
            return choiceListSelect == RETRIEVAL_METHOD_CHOICE;
        }

        /** 
         * Get the 'RetrievalMethod' element value.
         * 
         * @return value
         */
        public RetrievalMethodType getRetrievalMethod() {
            return retrievalMethod;
        }

        /** 
         * Set the 'RetrievalMethod' element value.
         * 
         * @param retrievalMethod
         */
        public void setRetrievalMethod(RetrievalMethodType retrievalMethod) {
            setChoiceListSelect(RETRIEVAL_METHOD_CHOICE);
            this.retrievalMethod = retrievalMethod;
        }

        /** 
         * Check if X509Data is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifX509Data() {
            return choiceListSelect == X509_DATA_CHOICE;
        }

        /** 
         * Get the 'X509Data' element value.
         * 
         * @return value
         */
        public X509DataType getX509Data() {
            return x509Data;
        }

        /** 
         * Set the 'X509Data' element value.
         * 
         * @param x509Data
         */
        public void setX509Data(X509DataType x509Data) {
            setChoiceListSelect(X509_DATA_CHOICE);
            this.x509Data = x509Data;
        }

        /** 
         * Check if PGPData is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPGPData() {
            return choiceListSelect == PGP_DATA_CHOICE;
        }

        /** 
         * Get the 'PGPData' element value.
         * 
         * @return value
         */
        public PGPDataType getPGPData() {
            return PGPData;
        }

        /** 
         * Set the 'PGPData' element value.
         * 
         * @param PGPData
         */
        public void setPGPData(PGPDataType PGPData) {
            setChoiceListSelect(PGP_DATA_CHOICE);
            this.PGPData = PGPData;
        }

        /** 
         * Check if SPKIData is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSPKIData() {
            return choiceListSelect == SPKI_DATA_CHOICE;
        }

        /** 
         * Get the 'SPKIData' element value.
         * 
         * @return value
         */
        public SPKIDataType getSPKIData() {
            return SPKIData;
        }

        /** 
         * Set the 'SPKIData' element value.
         * 
         * @param SPKIData
         */
        public void setSPKIData(SPKIDataType SPKIData) {
            setChoiceListSelect(SPKI_DATA_CHOICE);
            this.SPKIData = SPKIData;
        }

        /** 
         * Check if MgmtData is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMgmtData() {
            return choiceListSelect == MGMT_DATA_CHOICE;
        }

        /** 
         * Get the 'MgmtData' element value.
         * 
         * @return value
         */
        public MgmtData getMgmtData() {
            return mgmtData;
        }

        /** 
         * Set the 'MgmtData' element value.
         * 
         * @param mgmtData
         */
        public void setMgmtData(MgmtData mgmtData) {
            setChoiceListSelect(MGMT_DATA_CHOICE);
            this.mgmtData = mgmtData;
        }

        /** 
         * Check if Any is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAny() {
            return choiceListSelect == ANY_CHOICE;
        }

        /** 
         * Get the any value.
         * 
         * @return value
         */
        public Element getAny() {
            return any;
        }

        /** 
         * Set the any value.
         * 
         * @param any
         */
        public void setAny(Element any) {
            setChoiceListSelect(ANY_CHOICE);
            this.any = any;
        }
    }
}
