
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A base type for a Keyed Object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="KeyObjectBaseType">
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="PricedInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class KeyObjectBaseType implements Serializable
{
    private ObjectKeyAttrGroup objectKeyAttrGroup;
    private Boolean pricedInd;

    /** 
     * Get the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
        return objectKeyAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @param objectKeyAttrGroup
     */
    public void setObjectKeyAttrGroup(ObjectKeyAttrGroup objectKeyAttrGroup) {
        this.objectKeyAttrGroup = objectKeyAttrGroup;
    }

    /** 
     * Get the 'PricedInd' attribute value. When true, Corporate Fare Information was used for Pricing.
     * 
     * @return value
     */
    public Boolean getPricedInd() {
        return pricedInd;
    }

    /** 
     * Set the 'PricedInd' attribute value. When true, Corporate Fare Information was used for Pricing.
     * 
     * @param pricedInd
     */
    public void setPricedInd(Boolean pricedInd) {
        this.pricedInd = pricedInd;
    }
}
