
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" mixed="true" name="KeyValueType">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="DSAKeyValue"/>
 *     &lt;xs:element ref="RSAKeyValue"/>
 *     &lt;xs:any processContents="lax" namespace="##other"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class KeyValueType implements Serializable
{
    private int choiceSelect = -1;
    private static final int DSA_KEY_VALUE_CHOICE = 0;
    private static final int RSA_KEY_VALUE_CHOICE = 1;
    private static final int ANY_CHOICE = 2;
    private DSAKeyValueType DSAKeyValue;
    private RSAKeyValueType RSAKeyValue;
    private Element any;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if DSAKeyValue is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDSAKeyValue() {
        return choiceSelect == DSA_KEY_VALUE_CHOICE;
    }

    /** 
     * Get the 'DSAKeyValue' element value.
     * 
     * @return value
     */
    public DSAKeyValueType getDSAKeyValue() {
        return DSAKeyValue;
    }

    /** 
     * Set the 'DSAKeyValue' element value.
     * 
     * @param DSAKeyValue
     */
    public void setDSAKeyValue(DSAKeyValueType DSAKeyValue) {
        setChoiceSelect(DSA_KEY_VALUE_CHOICE);
        this.DSAKeyValue = DSAKeyValue;
    }

    /** 
     * Check if RSAKeyValue is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRSAKeyValue() {
        return choiceSelect == RSA_KEY_VALUE_CHOICE;
    }

    /** 
     * Get the 'RSAKeyValue' element value.
     * 
     * @return value
     */
    public RSAKeyValueType getRSAKeyValue() {
        return RSAKeyValue;
    }

    /** 
     * Set the 'RSAKeyValue' element value.
     * 
     * @param RSAKeyValue
     */
    public void setRSAKeyValue(RSAKeyValueType RSAKeyValue) {
        setChoiceSelect(RSA_KEY_VALUE_CHOICE);
        this.RSAKeyValue = RSAKeyValue;
    }

    /** 
     * Check if Any is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAny() {
        return choiceSelect == ANY_CHOICE;
    }

    /** 
     * Get the any value.
     * 
     * @return value
     */
    public Element getAny() {
        return any;
    }

    /** 
     * Set the any value.
     * 
     * @param any
     */
    public void setAny(Element any) {
        setChoiceSelect(ANY_CHOICE);
        this.any = any;
    }
}
