
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * KEYWORD/ VALUE PAIR object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="KeyWordType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Word" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Value" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class KeyWordType implements Serializable
{
    private String word;
    private List<String> valueList = new ArrayList<String>();
    private ObjectKeyAttrGroup objectKeyAttrGroup;

    /** 
     * Get the 'Word' element value. Key Word. Example: SKYC
     * 
     * @return value
     */
    public String getWord() {
        return word;
    }

    /** 
     * Set the 'Word' element value. Key Word. Example: SKYC
     * 
     * @param word
     */
    public void setWord(String word) {
        this.word = word;
    }

    /** 
     * Get the list of 'Value' element items. Key-Word Value(s). Example: SkyCouch
     * 
     * @return list
     */
    public List<String> getValueList() {
        return valueList;
    }

    /** 
     * Set the list of 'Value' element items. Key-Word Value(s). Example: SkyCouch
     * 
     * @param list
     */
    public void setValueList(List<String> list) {
        valueList = list;
    }

    /** 
     * Get the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
        return objectKeyAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @param objectKeyAttrGroup
     */
    public void setObjectKeyAttrGroup(ObjectKeyAttrGroup objectKeyAttrGroup) {
        this.objectKeyAttrGroup = objectKeyAttrGroup;
    }
}
