
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Language Code Application list constraint.

 Examples: Display, Requested, Spoken, Written, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LanguageAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Actual"/>
 *     &lt;xs:enumeration value="Requested"/>
 *     &lt;xs:enumeration value="Spoken"/>
 *     &lt;xs:enumeration value="Written"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum LanguageAppListType implements Serializable {
    ACTUAL("Actual"), REQUESTED("Requested"), SPOKEN("Spoken"), WRITTEN(
            "Written"), OTHER("Other");
    private final String value;

    private LanguageAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static LanguageAppListType convert(String value) {
        for (LanguageAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
