
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Language Code representation.

 Notes:
 1. Language code.  Example: en, en-US

 2. Encoding Schemes: ISO 639-1 Code OR Microsoft National Language Support (NLS) Code

 3. Supports ISO 639-1 (two alpha character) neutral language encoding indicated by a name such as "en" for English.

 4.  Supports MNLS geographically specific language encoding indicated by a name that includes both locale and country/region information. For example, the locale English (United States) has the language name "en-US".NDC Capability Model: LANGUAGE ENCODING

 ============
 Representation(s)
 ============
 • ISO 639-1 encoding
 • Microsoft MNLS geographically specific language encoding

 ============
 Feature(s)
 ============
 • Supports ISO 639-1 (two alpha character) neutral language encoding indicated by a name such as "en" for English.

 • Supports MNLS geographically specific language encoding indicated by a name that includes both locale and country/region information. For example, the locale English (United States) has the language name "en-US".

 • Language application (e.g. usage context) may be specified (Display, Requested, Spoken, Written, etc.)

 ============
 Metadata
 ============
 • LanguageMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LanguageCodeType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attributeGroup ref="ns:ObjectKeyMetaAttrGroup"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LanguageCodeType implements Serializable
{
    private String string;
    private ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyMetaAttrGroup getObjectKeyMetaAttrGroup() {
        return objectKeyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @param objectKeyMetaAttrGroup
     */
    public void setObjectKeyMetaAttrGroup(
            ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup) {
        this.objectKeyMetaAttrGroup = objectKeyMetaAttrGroup;
    }
}
