
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Language Code representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LanguageUsageType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="LanguageCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LanguageUsage" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LanguageUsageType implements Serializable
{
    private String languageCode;
    private String languageUsage;

    /** 
     * Get the 'LanguageCode' element value. Language Code representation.

    Notes:
    1. Language code.  Example: en, en-US
    2. Encoding Schemes: ISO 639-1 Code OR Microsoft National Language Support (NLS) Code
    3. Supports ISO 639-1 (two alpha character) neutral language encoding indicated by a name such as "en" for English.
    4.  Supports MNLS geographically specific language encoding indicated by a name that includes both locale and country/region information. For example, the locale English (United States) has the language name "en-US"
     * 
     * @return value
     */
    public String getLanguageCode() {
        return languageCode;
    }

    /** 
     * Set the 'LanguageCode' element value. Language Code representation.

    Notes:
    1. Language code.  Example: en, en-US
    2. Encoding Schemes: ISO 639-1 Code OR Microsoft National Language Support (NLS) Code
    3. Supports ISO 639-1 (two alpha character) neutral language encoding indicated by a name such as "en" for English.
    4.  Supports MNLS geographically specific language encoding indicated by a name that includes both locale and country/region information. For example, the locale English (United States) has the language name "en-US"
     * 
     * @param languageCode
     */
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    /** 
     * Get the 'LanguageUsage' element value. Written or Spoken language.
     * 
     * @return value
     */
    public String getLanguageUsage() {
        return languageUsage;
    }

    /** 
     * Set the 'LanguageUsage' element value. Written or Spoken language.
     * 
     * @param languageUsage
     */
    public void setLanguageUsage(String languageUsage) {
        this.languageUsage = languageUsage;
    }
}
