
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * LEAD DATE PERIOD representation.

 Notes: Supports Calendar Shopping. Days, Months, etc. before and/ or after the specified date.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LeadDatePeriodType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Before"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="After"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class LeadDatePeriodType implements Serializable
{
    private String before;
    private String after;
    private String refs;

    /** 
     * Get the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @return value
     */
    public String getBefore() {
        return before;
    }

    /** 
     * Set the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @param before
     */
    public void setBefore(String before) {
        this.before = before;
    }

    /** 
     * Get the 'After' attribute value. The period duration to be applied AFTER the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @return value
     */
    public String getAfter() {
        return after;
    }

    /** 
     * Set the 'After' attribute value. The period duration to be applied AFTER the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @param after
     */
    public void setAfter(String after) {
        this.after = after;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
