
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * US DOT BAGGAGE RULE data list definition.Select a value from the enumerated list or enter a string value.
 =enumerated values=
 N = NOT SUBJECT TO US DOT RESERVATION OR DISCLOSURE
 Y = SUBJECT TO US DOT RESERVATION AND DISCLOSURE
 D = SUBJECT TO DISCLOSURE BUT NOT TO US DOT RESERVATION
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfBagDisclosureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BagDisclosure" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BagDisclosure -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfBagDisclosureType implements Serializable
{
    private List<BagDisclosure> bagDisclosureList = new ArrayList<BagDisclosure>();

    /** 
     * Get the list of 'BagDisclosure' element items.
     * 
     * @return list
     */
    public List<BagDisclosure> getBagDisclosureList() {
        return bagDisclosureList;
    }

    /** 
     * Set the list of 'BagDisclosure' element items.
     * 
     * @param list
     */
    public void setBagDisclosureList(List<BagDisclosure> list) {
        bagDisclosureList = list;
    }
    /** 
     * Baggage Disclosure detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDisclosure" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="BagRule"/>
     *       &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
     *       &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:DataListObjAttrGroup"/>
     *     &lt;xs:attribute type="xs:boolean" name="CheckInTFC_ApplicableInd"/>
     *     &lt;xs:attribute type="xs:boolean" name="DeferralInd"/>
     *     &lt;xs:attribute type="xs:string" name="CommercialAgreementID"/>
     *     &lt;xs:attribute type="xs:boolean" name="FixedPrePaidInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagDisclosure implements Serializable
    {
        private String bagRule;
        private Descriptions descriptions;
        private BaggageDeterminingCarrierType baggageDeterminingCarrier;
        private DataListObjAttrGroup dataListObjAttrGroup;
        private Boolean checkInTFCApplicableInd;
        private Boolean deferralInd;
        private String commercialAgreementID;
        private Boolean fixedPrePaidInd;

        /** 
         * Get the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
        Examples: Y, Disclosure AND US DOT Reservation
         * 
         * @return value
         */
        public String getBagRule() {
            return bagRule;
        }

        /** 
         * Set the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
        Examples: Y, Disclosure AND US DOT Reservation
         * 
         * @param bagRule
         */
        public void setBagRule(String bagRule) {
            this.bagRule = bagRule;
        }

        /** 
         * Get the 'Descriptions' element value.
         * 
         * @return value
         */
        public Descriptions getDescriptions() {
            return descriptions;
        }

        /** 
         * Set the 'Descriptions' element value.
         * 
         * @param descriptions
         */
        public void setDescriptions(Descriptions descriptions) {
            this.descriptions = descriptions;
        }

        /** 
         * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
         * 
         * @return value
         */
        public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
            return baggageDeterminingCarrier;
        }

        /** 
         * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
         * 
         * @param baggageDeterminingCarrier
         */
        public void setBaggageDeterminingCarrier(
                BaggageDeterminingCarrierType baggageDeterminingCarrier) {
            this.baggageDeterminingCarrier = baggageDeterminingCarrier;
        }

        /** 
         * Get the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public DataListObjAttrGroup getDataListObjAttrGroup() {
            return dataListObjAttrGroup;
        }

        /** 
         * Set the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @param dataListObjAttrGroup
         */
        public void setDataListObjAttrGroup(
                DataListObjAttrGroup dataListObjAttrGroup) {
            this.dataListObjAttrGroup = dataListObjAttrGroup;
        }

        /** 
         * Get the 'CheckInTFC_ApplicableInd' attribute value. If True: Additional Taxes, Fees and Charges may be collected at check-in (regionally determined).
         * 
         * @return value
         */
        public Boolean getCheckInTFCApplicableInd() {
            return checkInTFCApplicableInd;
        }

        /** 
         * Set the 'CheckInTFC_ApplicableInd' attribute value. If True: Additional Taxes, Fees and Charges may be collected at check-in (regionally determined).
         * 
         * @param checkInTFCApplicableInd
         */
        public void setCheckInTFCApplicableInd(Boolean checkInTFCApplicableInd) {
            this.checkInTFCApplicableInd = checkInTFCApplicableInd;
        }

        /** 
         * Get the 'DeferralInd' attribute value. If True, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation
         * 
         * @return value
         */
        public Boolean getDeferralInd() {
            return deferralInd;
        }

        /** 
         * Set the 'DeferralInd' attribute value. If True, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation
         * 
         * @param deferralInd
         */
        public void setDeferralInd(Boolean deferralInd) {
            this.deferralInd = deferralInd;
        }

        /** 
         * Get the 'CommercialAgreementID' attribute value. Bi-lateral agreement identifier, i.e. - baggage cost, Baggage Determining Carrier, etc.
         * 
         * @return value
         */
        public String getCommercialAgreementID() {
            return commercialAgreementID;
        }

        /** 
         * Set the 'CommercialAgreementID' attribute value. Bi-lateral agreement identifier, i.e. - baggage cost, Baggage Determining Carrier, etc.
         * 
         * @param commercialAgreementID
         */
        public void setCommercialAgreementID(String commercialAgreementID) {
            this.commercialAgreementID = commercialAgreementID;
        }

        /** 
         * Get the 'FixedPrePaidInd' attribute value. Allows POA to tell the ORA if the ORA may alter the POA’s pre-paid baggage charges

        If True: prepaid charge may NOT be altered
        If False: prepaid charge MAY be altered
         * 
         * @return value
         */
        public Boolean getFixedPrePaidInd() {
            return fixedPrePaidInd;
        }

        /** 
         * Set the 'FixedPrePaidInd' attribute value. Allows POA to tell the ORA if the ORA may alter the POA’s pre-paid baggage charges

        If True: prepaid charge may NOT be altered
        If False: prepaid charge MAY be altered
         * 
         * @param fixedPrePaidInd
         */
        public void setFixedPrePaidInd(Boolean fixedPrePaidInd) {
            this.fixedPrePaidInd = fixedPrePaidInd;
        }
    }
}
