
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Flight origin/ destination information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfFlightSegmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:Departure"/>
 *     &lt;xs:element ref="ns:Arrival"/>
 *     &lt;xs:element type="ns:MarketingCarrierFlightType" name="MarketingCarrier"/>
 *     &lt;xs:element name="OperatingCarrier" minOccurs="0">
 *       &lt;!-- Reference to inner class OperatingCarrier -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:Equipment" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightDetailType" name="FlightDetail" minOccurs="0"/>
 *     &lt;xs:element ref="ns:OnTimePerformance" minOccurs="0"/>
 *     &lt;xs:element name="Settlement" minOccurs="0">
 *       &lt;!-- Reference to inner class Settlement -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="SegmentKey"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ConnectInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ElectronicTicketInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="TicketlessInd"/>
 *   &lt;xs:attribute type="xs:boolean" name="SecureFlight"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ListOfFlightSegmentType implements Serializable
{
    private FlightDepartureType departure;
    private FlightArrivalType arrival;
    private MarketingCarrierFlightType marketingCarrier;
    private OperatingCarrier operatingCarrier;
    private AircraftSummaryType equipment;
    private FlightCOSCoreType classOfService;
    private FlightDetailType flightDetail;
    private OnTimePerformance onTimePerformance;
    private Settlement settlement;
    private String refs;
    private String segmentKey;
    private Boolean connectInd;
    private Boolean electronicTicketInd;
    private Boolean ticketlessInd;
    private Boolean secureFlight;

    /** 
     * Get the 'Departure' element value.
     * 
     * @return value
     */
    public FlightDepartureType getDeparture() {
        return departure;
    }

    /** 
     * Set the 'Departure' element value.
     * 
     * @param departure
     */
    public void setDeparture(FlightDepartureType departure) {
        this.departure = departure;
    }

    /** 
     * Get the 'Arrival' element value.
     * 
     * @return value
     */
    public FlightArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value.
     * 
     * @param arrival
     */
    public void setArrival(FlightArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'MarketingCarrier' element value. Marketing Carrier information.
     * 
     * @return value
     */
    public MarketingCarrierFlightType getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value. Marketing Carrier information.
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(MarketingCarrierFlightType marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Get the 'OperatingCarrier' element value.
     * 
     * @return value
     */
    public OperatingCarrier getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value.
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'Equipment' element value.
     * 
     * @return value
     */
    public AircraftSummaryType getEquipment() {
        return equipment;
    }

    /** 
     * Set the 'Equipment' element value.
     * 
     * @param equipment
     */
    public void setEquipment(AircraftSummaryType equipment) {
        this.equipment = equipment;
    }

    /** 
     * Get the 'ClassOfService' element value.
     * 
     * @return value
     */
    public FlightCOSCoreType getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value.
     * 
     * @param classOfService
     */
    public void setClassOfService(FlightCOSCoreType classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'FlightDetail' element value. Flight Details.
     * 
     * @return value
     */
    public FlightDetailType getFlightDetail() {
        return flightDetail;
    }

    /** 
     * Set the 'FlightDetail' element value. Flight Details.
     * 
     * @param flightDetail
     */
    public void setFlightDetail(FlightDetailType flightDetail) {
        this.flightDetail = flightDetail;
    }

    /** 
     * Get the 'OnTimePerformance' element value.
     * 
     * @return value
     */
    public OnTimePerformance getOnTimePerformance() {
        return onTimePerformance;
    }

    /** 
     * Set the 'OnTimePerformance' element value.
     * 
     * @param onTimePerformance
     */
    public void setOnTimePerformance(OnTimePerformance onTimePerformance) {
        this.onTimePerformance = onTimePerformance;
    }

    /** 
     * Get the 'Settlement' element value.
     * 
     * @return value
     */
    public Settlement getSettlement() {
        return settlement;
    }

    /** 
     * Set the 'Settlement' element value.
     * 
     * @param settlement
     */
    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'SegmentKey' attribute value. A globally unique identifier for this Flight Segment instance. Example: segment1
     * 
     * @return value
     */
    public String getSegmentKey() {
        return segmentKey;
    }

    /** 
     * Set the 'SegmentKey' attribute value. A globally unique identifier for this Flight Segment instance. Example: segment1
     * 
     * @param segmentKey
     */
    public void setSegmentKey(String segmentKey) {
        this.segmentKey = segmentKey;
    }

    /** 
     * Get the 'ConnectInd' attribute value. When true, there are one or more connections for this flight.
     * 
     * @return value
     */
    public Boolean getConnectInd() {
        return connectInd;
    }

    /** 
     * Set the 'ConnectInd' attribute value. When true, there are one or more connections for this flight.
     * 
     * @param connectInd
     */
    public void setConnectInd(Boolean connectInd) {
        this.connectInd = connectInd;
    }

    /** 
     * Get the 'ElectronicTicketInd' attribute value. When true, an electronic ticket may be issued.
     * 
     * @return value
     */
    public Boolean getElectronicTicketInd() {
        return electronicTicketInd;
    }

    /** 
     * Set the 'ElectronicTicketInd' attribute value. When true, an electronic ticket may be issued.
     * 
     * @param electronicTicketInd
     */
    public void setElectronicTicketInd(Boolean electronicTicketInd) {
        this.electronicTicketInd = electronicTicketInd;
    }

    /** 
     * Get the 'TicketlessInd' attribute value. When true, the fare can be purchased without issuing a ticket.
     * 
     * @return value
     */
    public Boolean getTicketlessInd() {
        return ticketlessInd;
    }

    /** 
     * Set the 'TicketlessInd' attribute value. When true, the fare can be purchased without issuing a ticket.
     * 
     * @param ticketlessInd
     */
    public void setTicketlessInd(Boolean ticketlessInd) {
        this.ticketlessInd = ticketlessInd;
    }

    /** 
     * Get the 'SecureFlight' attribute value. When true, the flight is secure flight. An indicator to disclose when a flight is a "secure flight"
     * 
     * @return value
     */
    public Boolean getSecureFlight() {
        return secureFlight;
    }

    /** 
     * Set the 'SecureFlight' attribute value. When true, the flight is secure flight. An indicator to disclose when a flight is a "secure flight"
     * 
     * @param secureFlight
     */
    public void setSecureFlight(Boolean secureFlight) {
        this.secureFlight = secureFlight;
    }
    /** 
     * Operating Carrier Information.

    Operating Carrier is the carrier that operates a flight with a reference to its own prime flight number.

    Note: Operating Carrier may be different from a Marketing Carrier(s), if the flight is actually marketed by another carrier(s) within a codeshare agreement. 

    Operating Carrier may not be the AOC holder, in which case, and wherever required, this will need to be disclosed to the customer.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OperatingCarrierFlightType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OperatingCarrier extends OperatingCarrierFlightType
        implements Serializable
    {
        private DisclosureType disclosures;

        /** 
         * Get the 'Disclosures' element value.
         * 
         * @return value
         */
        public DisclosureType getDisclosures() {
            return disclosures;
        }

        /** 
         * Set the 'Disclosures' element value.
         * 
         * @param disclosures
         */
        public void setDisclosures(DisclosureType disclosures) {
            this.disclosures = disclosures;
        }
    }
    /** 
     * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Method"/>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Settlement implements Serializable
    {
        private String method;
        private CurrencyAmountOptType interlineSettlementValue;

        /** 
         * Get the 'Method' element value. Service settlement method.
        Examples:
        AD (Internal Airline Document)
        DS (Direct Settlement)
        EA (EMD Associated or Internal Airline Document)
        ES (EMD Standalone )
        FI (Fare Integrated)
        MA (Flight Associated, Settled via MCO)
        MS (Standalone, Settled via MCO)

        Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
         * 
         * @return value
         */
        public String getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value. Service settlement method.
        Examples:
        AD (Internal Airline Document)
        DS (Direct Settlement)
        EA (EMD Associated or Internal Airline Document)
        ES (EMD Standalone )
        FI (Fare Integrated)
        MA (Flight Associated, Settled via MCO)
        MS (Standalone, Settled via MCO)

        Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
         * 
         * @param method
         */
        public void setMethod(String method) {
            this.method = method;
        }

        /** 
         * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

        Note: This represents a Settlement value that is only used between the POA and ORA.
         * 
         * @return value
         */
        public CurrencyAmountOptType getInterlineSettlementValue() {
            return interlineSettlementValue;
        }

        /** 
         * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

        Note: This represents a Settlement value that is only used between the POA and ORA.
         * 
         * @param interlineSettlementValue
         */
        public void setInterlineSettlementValue(
                CurrencyAmountOptType interlineSettlementValue) {
            this.interlineSettlementValue = interlineSettlementValue;
        }
    }
}
