
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * MEDIA data list definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfMediaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Media" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Media -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfMediaType implements Serializable
{
    private List<Media> mediaList = new ArrayList<Media>();

    /** 
     * Get the list of 'Media' element items.
     * 
     * @return list
     */
    public List<Media> getMediaList() {
        return mediaList;
    }

    /** 
     * Set the list of 'Media' element items.
     * 
     * @param list
     */
    public void setMediaList(List<Media> list) {
        mediaList = list;
    }
    /** 
     * Media Choices.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Media" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:UniqueIDContextType" name="ObjectID" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MediaLink" minOccurs="0"/>
     *       &lt;xs:element type="ns:UniqueIDContextType" name="AttachmentID" minOccurs="0"/>
     *       &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:DataListObjAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Media implements Serializable
    {
        private UniqueIDContextType objectID;
        private MediaLink mediaLink;
        private UniqueIDContextType attachmentID;
        private Descriptions descriptions;
        private DataListObjAttrGroup dataListObjAttrGroup;

        /** 
         * Get the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
         * 
         * @return value
         */
        public UniqueIDContextType getObjectID() {
            return objectID;
        }

        /** 
         * Set the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
         * 
         * @param objectID
         */
        public void setObjectID(UniqueIDContextType objectID) {
            this.objectID = objectID;
        }

        /** 
         * Get the 'MediaLink' element value. Description-associated MEDIA LINK.
         * 
         * @return value
         */
        public MediaLink getMediaLink() {
            return mediaLink;
        }

        /** 
         * Set the 'MediaLink' element value. Description-associated MEDIA LINK.
         * 
         * @param mediaLink
         */
        public void setMediaLink(MediaLink mediaLink) {
            this.mediaLink = mediaLink;
        }

        /** 
         * Get the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
         * 
         * @return value
         */
        public UniqueIDContextType getAttachmentID() {
            return attachmentID;
        }

        /** 
         * Set the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
         * 
         * @param attachmentID
         */
        public void setAttachmentID(UniqueIDContextType attachmentID) {
            this.attachmentID = attachmentID;
        }

        /** 
         * Get the 'Descriptions' element value.
         * 
         * @return value
         */
        public Descriptions getDescriptions() {
            return descriptions;
        }

        /** 
         * Set the 'Descriptions' element value.
         * 
         * @param descriptions
         */
        public void setDescriptions(Descriptions descriptions) {
            this.descriptions = descriptions;
        }

        /** 
         * Get the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public DataListObjAttrGroup getDataListObjAttrGroup() {
            return dataListObjAttrGroup;
        }

        /** 
         * Set the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @param dataListObjAttrGroup
         */
        public void setDataListObjAttrGroup(
                DataListObjAttrGroup dataListObjAttrGroup) {
            this.dataListObjAttrGroup = dataListObjAttrGroup;
        }
    }
}
