
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Payload Content Localization Notice definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocalizationNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Languages" minOccurs="0"/>
 *         &lt;xs:element name="Currencies" minOccurs="0">
 *           &lt;!-- Reference to inner class Currencies -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LocalizationNoticeType extends TrxProcessObjectBaseType implements
    Serializable
{
    private Languages languages;
    private Currencies currencies;

    /** 
     * Get the 'Languages' element value. 
                  Payload Content Language Representation Code(s). Notes: 1. Payload content localized language representation in support of I18N aware systems. 2. Language Code context is specified in the @Application attribute, e.g. Requested, Display.
                
     * 
     * @return value
     */
    public Languages getLanguages() {
        return languages;
    }

    /** 
     * Set the 'Languages' element value. 
                  Payload Content Language Representation Code(s). Notes: 1. Payload content localized language representation in support of I18N aware systems. 2. Language Code context is specified in the @Application attribute, e.g. Requested, Display.
                
     * 
     * @param languages
     */
    public void setLanguages(Languages languages) {
        this.languages = languages;
    }

    /** 
     * Get the 'Currencies' element value.
     * 
     * @return value
     */
    public Currencies getCurrencies() {
        return currencies;
    }

    /** 
     * Set the 'Currencies' element value.
     * 
     * @param currencies
     */
    public void setCurrencies(Currencies currencies) {
        this.currencies = currencies;
    }
    /** 
     * 
                  Payload Content Currency Representation Code(s). Notes: 1. Payload content localized currency representation in support of I18N aware systems. 2. Currency Code context is specified in the @Application attribute, e.g. Requested, Display. 3. This is not the point of sale currency that is specified in the PointOfSale node.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Currencies" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:CurrCode" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Currencies implements Serializable
    {
        private List<CurrCode> currCodeList = new ArrayList<CurrCode>();

        /** 
         * Get the list of 'CurrCode' element items.
         * 
         * @return list
         */
        public List<CurrCode> getCurrCodeList() {
            return currCodeList;
        }

        /** 
         * Set the list of 'CurrCode' element items.
         * 
         * @param list
         */
        public void setCurrCodeList(List<CurrCode> list) {
            currCodeList = list;
        }
    }
}
