
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * LOCATION PROXIMITY definition.

 Note: This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationProximityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Application"/>
 *     &lt;xs:element type="xs:decimal" name="AreaValue"/>
 *     &lt;xs:element type="xs:string" name="UOM" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class LocationProximityType implements Serializable
{
    private String application;
    private BigDecimal areaValue;
    private String UOM;
    private String refs;

    /** 
     * Get the 'Application' element value. Proximity Data Application.  Example: SearchRadius, ActualProximity, Other
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Proximity Data Application.  Example: SearchRadius, ActualProximity, Other
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'AreaValue' element value. The actual distance value from the named location  search.  Example: 20
     * 
     * @return value
     */
    public BigDecimal getAreaValue() {
        return areaValue;
    }

    /** 
     * Set the 'AreaValue' element value. The actual distance value from the named location  search.  Example: 20
     * 
     * @param areaValue
     */
    public void setAreaValue(BigDecimal areaValue) {
        this.areaValue = areaValue;
    }

    /** 
     * Get the 'UOM' element value. Distance unit of measure. Examples: Miles, Kilometers
     * 
     * @return value
     */
    public String getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' element value. Distance unit of measure. Examples: Miles, Kilometers
     * 
     * @param UOM
     */
    public void setUOM(String UOM) {
        this.UOM = UOM;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
