
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for MARKETING CARRIER Supplier Role with Mandatory Flight Number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingCarrierFlightType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:AirlineID"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FlightNumber"/>
 *     &lt;xs:element type="xs:string" name="ResBookDesigCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MarketingCarrierFlightType implements Serializable
{
    private AirlineIDType airlineID;
    private String name;
    private FlightNumber flightNumber;
    private String resBookDesigCode;
    private String refs;

    /** 
     * Get the 'AirlineID' element value.
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value.
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'FlightNumber' element value.
     * 
     * @return value
     */
    public FlightNumber getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(FlightNumber flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ResBookDesigCode' element value. The Reservation Booking Designator (booking class) of the Marketing Carrier. Example: Y
     * 
     * @return value
     */
    public String getResBookDesigCode() {
        return resBookDesigCode;
    }

    /** 
     * Set the 'ResBookDesigCode' element value. The Reservation Booking Designator (booking class) of the Marketing Carrier. Example: Y
     * 
     * @param resBookDesigCode
     */
    public void setResBookDesigCode(String resBookDesigCode) {
        this.resBookDesigCode = resBookDesigCode;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
