
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Marketing Messages in a response message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Message" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Message -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MarketingInfoType implements Serializable
{
    private List<Message> messageList = new ArrayList<Message>();
    private String refs;

    /** 
     * Get the list of 'Message' element items.
     * 
     * @return list
     */
    public List<Message> getMessageList() {
        return messageList;
    }

    /** 
     * Set the list of 'Message' element items.
     * 
     * @param list
     */
    public void setMessageList(List<Message> list) {
        messageList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Marketing message.
    Example: ONE Traveler MAY BE ELIGIBLE FOR A FREE SEAT
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Message" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DescriptionType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:MarketMsgAssocType" name="Associations" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Message extends DescriptionType implements Serializable
    {
        private MarketMsgAssocType associations;

        /** 
         * Get the 'Associations' element value. Marketing Message Association(s).
         * 
         * @return value
         */
        public MarketMsgAssocType getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. Marketing Message Association(s).
         * 
         * @param associations
         */
        public void setAssociations(MarketMsgAssocType associations) {
            this.associations = associations;
        }
    }
}
