
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Associated Media definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaAssocType">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="ns:MediaGroupreference"/>
 *     &lt;xs:element name="MediaItems" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class MediaItems -->
 *     &lt;/xs:element>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MediaAssocType implements Serializable
{
    private int choiceSelect = -1;
    private static final int MEDIA_GROUPREFERENCE_CHOICE = 0;
    private static final int MEDIA_ITEM_LIST_CHOICE = 1;
    private MediaGroupreference mediaGroupreference;
    private List<MediaItems> mediaItemList = new ArrayList<MediaItems>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if MediaGroupreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMediaGroupreference() {
        return choiceSelect == MEDIA_GROUPREFERENCE_CHOICE;
    }

    /** 
     * Get the 'MediaGroupreference' element value.
     * 
     * @return value
     */
    public MediaGroupreference getMediaGroupreference() {
        return mediaGroupreference;
    }

    /** 
     * Set the 'MediaGroupreference' element value.
     * 
     * @param mediaGroupreference
     */
    public void setMediaGroupreference(MediaGroupreference mediaGroupreference) {
        setChoiceSelect(MEDIA_GROUPREFERENCE_CHOICE);
        this.mediaGroupreference = mediaGroupreference;
    }

    /** 
     * Check if MediaItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMediaItemList() {
        return choiceSelect == MEDIA_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'MediaItems' element items.
     * 
     * @return list
     */
    public List<MediaItems> getMediaItemList() {
        return mediaItemList;
    }

    /** 
     * Set the list of 'MediaItems' element items.
     * 
     * @param list
     */
    public void setMediaItemList(List<MediaItems> list) {
        setChoiceSelect(MEDIA_ITEM_LIST_CHOICE);
        mediaItemList = list;
    }
    /** 
     * Media Item detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaItems" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:MediaItemReference"/>
     *       &lt;xs:element type="xs:string" name="MediaLink"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MediaItems implements Serializable
    {
        private int mediaItemListSelect = -1;
        private static final int MEDIA_ITEM_REFERENCE_CHOICE = 0;
        private static final int MEDIA_LINK_CHOICE = 1;
        private MediaItemReference mediaItemReference;
        private String mediaLink;

        private void setMediaItemListSelect(int choice) {
            if (mediaItemListSelect == -1) {
                mediaItemListSelect = choice;
            } else if (mediaItemListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearMediaItemListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearMediaItemListSelect() {
            mediaItemListSelect = -1;
        }

        /** 
         * Check if MediaItemReference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMediaItemReference() {
            return mediaItemListSelect == MEDIA_ITEM_REFERENCE_CHOICE;
        }

        /** 
         * Get the 'MediaItemReference' element value.
         * 
         * @return value
         */
        public MediaItemReference getMediaItemReference() {
            return mediaItemReference;
        }

        /** 
         * Set the 'MediaItemReference' element value.
         * 
         * @param mediaItemReference
         */
        public void setMediaItemReference(MediaItemReference mediaItemReference) {
            setMediaItemListSelect(MEDIA_ITEM_REFERENCE_CHOICE);
            this.mediaItemReference = mediaItemReference;
        }

        /** 
         * Check if MediaLink is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMediaLink() {
            return mediaItemListSelect == MEDIA_LINK_CHOICE;
        }

        /** 
         * Get the 'MediaLink' element value. Associated Media URL.
         * 
         * @return value
         */
        public String getMediaLink() {
            return mediaLink;
        }

        /** 
         * Set the 'MediaLink' element value. Associated Media URL.
         * 
         * @param mediaLink
         */
        public void setMediaLink(String mediaLink) {
            setMediaItemListSelect(MEDIA_LINK_CHOICE);
            this.mediaLink = mediaLink;
        }
    }
}
