
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * MEDIA ATTACHMENT representation. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaAttachmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:ImageID" minOccurs="0"/>
 *     &lt;xs:element name="AttachmentURI" minOccurs="0">
 *       &lt;!-- Reference to inner class AttachmentURI -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Mimetype" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FileKbSize" minOccurs="0"/>
 *     &lt;xs:element type="ns:RenderingInstructionsType" name="Rendering" minOccurs="0"/>
 *     &lt;xs:element type="xs:base64Binary" name="Content" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MediaAttachmentType implements Serializable
{
    private ImageID imageID;
    private AttachmentURI attachmentURI;
    private String description;
    private String mimetype;
    private String fileKbSize;
    private RenderingInstructionsType rendering;
    private byte[] content;
    private String refs;

    /** 
     * Get the 'ImageID' element value.
     * 
     * @return value
     */
    public ImageID getImageID() {
        return imageID;
    }

    /** 
     * Set the 'ImageID' element value.
     * 
     * @param imageID
     */
    public void setImageID(ImageID imageID) {
        this.imageID = imageID;
    }

    /** 
     * Get the 'AttachmentURI' element value.
     * 
     * @return value
     */
    public AttachmentURI getAttachmentURI() {
        return attachmentURI;
    }

    /** 
     * Set the 'AttachmentURI' element value.
     * 
     * @param attachmentURI
     */
    public void setAttachmentURI(AttachmentURI attachmentURI) {
        this.attachmentURI = attachmentURI;
    }

    /** 
     * Get the 'Description' element value. Attachment Description.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Attachment Description.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'Mimetype' element value. MIME Type of binary content embedded in FileContent element or referenced by AttachmentURI element, eg. "application/pdf" or "image/png"  
     * 
     * @return value
     */
    public String getMimetype() {
        return mimetype;
    }

    /** 
     * Set the 'Mimetype' element value. MIME Type of binary content embedded in FileContent element or referenced by AttachmentURI element, eg. "application/pdf" or "image/png"  
     * 
     * @param mimetype
     */
    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    /** 
     * Get the 'FileKbSize' element value. The size of the Attachment in kilobytes. Example: 60
     * 
     * @return value
     */
    public String getFileKbSize() {
        return fileKbSize;
    }

    /** 
     * Set the 'FileKbSize' element value. The size of the Attachment in kilobytes. Example: 60
     * 
     * @param fileKbSize
     */
    public void setFileKbSize(String fileKbSize) {
        this.fileKbSize = fileKbSize;
    }

    /** 
     * Get the 'Rendering' element value. Rendered Media Instructions.
     * 
     * @return value
     */
    public RenderingInstructionsType getRendering() {
        return rendering;
    }

    /** 
     * Set the 'Rendering' element value. Rendered Media Instructions.
     * 
     * @param rendering
     */
    public void setRendering(RenderingInstructionsType rendering) {
        this.rendering = rendering;
    }

    /** 
     * Get the 'Content' element value. Base 64 binary content.
     * 
     * @return value
     */
    public byte[] getContent() {
        return content;
    }

    /** 
     * Set the 'Content' element value. Base 64 binary content.
     * 
     * @param content
     */
    public void setContent(byte[] content) {
        this.content = content;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Attachment Uniform Resource Identifier (URI).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AttachmentURI" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class AttachmentURI implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
