
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Business Object Parameters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageParamsBaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Languages" minOccurs="0">
 *       &lt;!-- Reference to inner class Languages -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CurrCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class CurrCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:MeasurementTypeListType" name="MeasurementSystem" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MessageParamsBaseType implements Serializable
{
    private Languages languages;
    private CurrCodes currCodes;
    private MeasurementTypeListType measurementSystem;
    private String refs;

    /** 
     * Get the 'Languages' element value.
     * 
     * @return value
     */
    public Languages getLanguages() {
        return languages;
    }

    /** 
     * Set the 'Languages' element value.
     * 
     * @param languages
     */
    public void setLanguages(Languages languages) {
        this.languages = languages;
    }

    /** 
     * Get the 'CurrCodes' element value.
     * 
     * @return value
     */
    public CurrCodes getCurrCodes() {
        return currCodes;
    }

    /** 
     * Set the 'CurrCodes' element value.
     * 
     * @param currCodes
     */
    public void setCurrCodes(CurrCodes currCodes) {
        this.currCodes = currCodes;
    }

    /** 
     * Get the 'MeasurementSystem' element value. Examples: Imperial, Metric
     * 
     * @return value
     */
    public MeasurementTypeListType getMeasurementSystem() {
        return measurementSystem;
    }

    /** 
     * Set the 'MeasurementSystem' element value. Examples: Imperial, Metric
     * 
     * @param measurementSystem
     */
    public void setMeasurementSystem(MeasurementTypeListType measurementSystem) {
        this.measurementSystem = measurementSystem;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Requested and/ or Actual Primary and/ or Alternate message content language(s).

    Note: Language context is specified in the @application attribute, e.g. Requested, Display.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Languages" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:LanguageCode" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Languages implements Serializable
    {
        private List<LanguageCodeType> languageCodeList = new ArrayList<LanguageCodeType>();

        /** 
         * Get the list of 'LanguageCode' element items.
         * 
         * @return list
         */
        public List<LanguageCodeType> getLanguageCodeList() {
            return languageCodeList;
        }

        /** 
         * Set the list of 'LanguageCode' element items.
         * 
         * @param list
         */
        public void setLanguageCodeList(List<LanguageCodeType> list) {
            languageCodeList = list;
        }
    }
    /** 
     * Requested search processing and results currency information.

    Notes:
    1. Currency context is specified in the @application attribute, e.g. Requested, Display.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FiledInCurrency" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FiledInCurrency -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CurrCodes implements Serializable
    {
        private List<FiledInCurrency> filedInCurrencyList = new ArrayList<FiledInCurrency>();

        /** 
         * Get the list of 'FiledInCurrency' element items.
         * 
         * @return list
         */
        public List<FiledInCurrency> getFiledInCurrencyList() {
            return filedInCurrencyList;
        }

        /** 
         * Set the list of 'FiledInCurrency' element items.
         * 
         * @param list
         */
        public void setFiledInCurrencyList(List<FiledInCurrency> list) {
            filedInCurrencyList = list;
        }
        /** 
         * This group represents fares filed in a currency different from the currency of a point of sale. The content elements represent the original currency and amount as filed.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FiledInCurrency" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:CurrCode"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FiledInCurrency implements Serializable
        {
            private CurrCode currCode;
            private String amount;

            /** 
             * Get the 'CurrCode' element value.
             * 
             * @return value
             */
            public CurrCode getCurrCode() {
                return currCode;
            }

            /** 
             * Set the 'CurrCode' element value.
             * 
             * @param currCode
             */
            public void setCurrCode(CurrCode currCode) {
                this.currCode = currCode;
            }

            /** 
             * Get the 'Amount' attribute value. Base Fare Amount as originally filed.
             * 
             * @return value
             */
            public String getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Base Fare Amount as originally filed.
             * 
             * @param amount
             */
            public void setAmount(String amount) {
                this.amount = amount;
            }
        }
    }
}
