
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Metadata object instance id and association(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetadataObjAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="metarefs"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MetadataKey"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MetadataObjAttrGroup implements Serializable
{
    private String metarefs;
    private String refs;
    private String metadataKey;

    /** 
     * Get the 'metarefs' attribute value. Association(s) between this metadata object and any metadata instance(s).
     * 
     * @return value
     */
    public String getMetarefs() {
        return metarefs;
    }

    /** 
     * Set the 'metarefs' attribute value. Association(s) between this metadata object and any metadata instance(s).
     * 
     * @param metarefs
     */
    public void setMetarefs(String metarefs) {
        this.metarefs = metarefs;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this metadata object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this metadata object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'MetadataKey' attribute value. A globally unique identifier for this Metadata instance.
     * 
     * @return value
     */
    public String getMetadataKey() {
        return metadataKey;
    }

    /** 
     * Set the 'MetadataKey' attribute value. A globally unique identifier for this Metadata instance.
     * 
     * @param metadataKey
     */
    public void setMetadataKey(String metadataKey) {
        this.metadataKey = metadataKey;
    }
}
