
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Base type for NDC Metadata Representation.

 Notes: Within NDC, metadata is defined as data about data. This may include information such as the security of a piece of data or the source of the data. These pieces of metadata may be composed into a metadata type. The types of data to which metadata may be applied may be constrained.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetadataObjectBaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MetadataKey"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MetadataObjectBaseType implements Serializable
{
    private AugPointInfoType augmentationPoint;
    private String refs;
    private String metadataKey;

    /** 
     * Get the 'AugmentationPoint' element value. Augmentation Point for this Metadata Structure.
     * 
     * @return value
     */
    public AugPointInfoType getAugmentationPoint() {
        return augmentationPoint;
    }

    /** 
     * Set the 'AugmentationPoint' element value. Augmentation Point for this Metadata Structure.
     * 
     * @param augmentationPoint
     */
    public void setAugmentationPoint(AugPointInfoType augmentationPoint) {
        this.augmentationPoint = augmentationPoint;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'MetadataKey' attribute value. A globally unique identifier for this Metadata instance.
     * 
     * @return value
     */
    public String getMetadataKey() {
        return metadataKey;
    }

    /** 
     * Set the 'MetadataKey' attribute value. A globally unique identifier for this Metadata instance.
     * 
     * @param metadataKey
     */
    public void setMetadataKey(String metadataKey) {
        this.metadataKey = metadataKey;
    }
}
