
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Effective/ Expiration Month Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MonthPeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MonthRepType" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="ns:MonthRepType" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MonthPeriodRepType implements Serializable
{
    private MonthRepType effective;
    private MonthRepType expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) month number.  Example: 01
     * 
     * @return value
     */
    public MonthRepType getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) month number.  Example: 01
     * 
     * @param effective
     */
    public void setEffective(MonthRepType effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) month number.  Example: 04
     * 
     * @return value
     */
    public MonthRepType getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) month number.  Example: 04
     * 
     * @param expiration
     */
    public void setExpiration(MonthRepType expiration) {
        this.expiration = expiration;
    }
}
