
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Common NDC Message Document Structures.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MsgDocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MetaBaseType" name="Metadata" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReferenceVersion" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MsgDocumentType implements Serializable
{
    private MetaBaseType metadata;
    private String name;
    private String referenceVersion;
    private String id;
    private String refs;

    /** 
     * Get the 'Metadata' element value. Document metadata
     * 
     * @return value
     */
    public MetaBaseType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Document metadata
     * 
     * @param metadata
     */
    public void setMetadata(MetaBaseType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Name' element value. NDC Implementation Name.
    Example: ThisAirline Gateway
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. NDC Implementation Name.
    Example: ThisAirline Gateway
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'ReferenceVersion' element value. NDC Framework Version. Example: SOAP 2015.1
     * 
     * @return value
     */
    public String getReferenceVersion() {
        return referenceVersion;
    }

    /** 
     * Set the 'ReferenceVersion' element value. NDC Framework Version. Example: SOAP 2015.1
     * 
     * @param referenceVersion
     */
    public void setReferenceVersion(String referenceVersion) {
        this.referenceVersion = referenceVersion;
    }

    /** 
     * Get the 'id' attribute value. A globally unique identifier for this object instance. 
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. A globally unique identifier for this object instance. 
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
