
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Transaction Processing Notice(s). Note: Notices contain information about specific NDC capabilities being utilized during transaction processing.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Notices">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Notice" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Notice -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Notices implements Serializable
{
    private List<Notice> noticeList = new ArrayList<Notice>();

    /** 
     * Get the list of 'Notice' element items.
     * 
     * @return list
     */
    public List<Notice> getNoticeList() {
        return noticeList;
    }

    /** 
     * Set the list of 'Notice' element items.
     * 
     * @param list
     */
    public void setNoticeList(List<Notice> list) {
        noticeList = list;
    }
    /** 
     * Notice detail. Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification.
              
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Notice" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:TaxExemptionNotice"/>
     *       &lt;xs:element ref="ns:ServiceFilterNotice"/>
     *       &lt;xs:element ref="ns:PricingParametersNotice"/>
     *       &lt;xs:element ref="ns:PriceVarianceNotice"/>
     *       &lt;xs:element ref="ns:PaymentRulesNotice"/>
     *       &lt;xs:element ref="ns:InventoryGuaranteeNotif"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Notice implements Serializable
    {
        private int noticeListSelect = -1;
        private static final int TAX_EXEMPTION_NOTICE_CHOICE = 0;
        private static final int SERVICE_FILTER_NOTICE_CHOICE = 1;
        private static final int PRICING_PARAMETERS_NOTICE_CHOICE = 2;
        private static final int PRICE_VARIANCE_NOTICE_CHOICE = 3;
        private static final int PAYMENT_RULES_NOTICE_CHOICE = 4;
        private static final int INVENTORY_GUARANTEE_NOTIF_CHOICE = 5;
        private TaxExemptionNoticeType taxExemptionNotice;
        private ServiceFilterNoticeType serviceFilterNotice;
        private PricingParametersNoticeType pricingParametersNotice;
        private PriceVarianceRuleNoticeType priceVarianceNotice;
        private PaymentRulesNoticeType paymentRulesNotice;
        private InvGuaranteeNoticeType inventoryGuaranteeNotif;

        private void setNoticeListSelect(int choice) {
            if (noticeListSelect == -1) {
                noticeListSelect = choice;
            } else if (noticeListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearNoticeListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearNoticeListSelect() {
            noticeListSelect = -1;
        }

        /** 
         * Check if TaxExemptionNotice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTaxExemptionNotice() {
            return noticeListSelect == TAX_EXEMPTION_NOTICE_CHOICE;
        }

        /** 
         * Get the 'TaxExemptionNotice' element value.
         * 
         * @return value
         */
        public TaxExemptionNoticeType getTaxExemptionNotice() {
            return taxExemptionNotice;
        }

        /** 
         * Set the 'TaxExemptionNotice' element value.
         * 
         * @param taxExemptionNotice
         */
        public void setTaxExemptionNotice(
                TaxExemptionNoticeType taxExemptionNotice) {
            setNoticeListSelect(TAX_EXEMPTION_NOTICE_CHOICE);
            this.taxExemptionNotice = taxExemptionNotice;
        }

        /** 
         * Check if ServiceFilterNotice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServiceFilterNotice() {
            return noticeListSelect == SERVICE_FILTER_NOTICE_CHOICE;
        }

        /** 
         * Get the 'ServiceFilterNotice' element value.
         * 
         * @return value
         */
        public ServiceFilterNoticeType getServiceFilterNotice() {
            return serviceFilterNotice;
        }

        /** 
         * Set the 'ServiceFilterNotice' element value.
         * 
         * @param serviceFilterNotice
         */
        public void setServiceFilterNotice(
                ServiceFilterNoticeType serviceFilterNotice) {
            setNoticeListSelect(SERVICE_FILTER_NOTICE_CHOICE);
            this.serviceFilterNotice = serviceFilterNotice;
        }

        /** 
         * Check if PricingParametersNotice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPricingParametersNotice() {
            return noticeListSelect == PRICING_PARAMETERS_NOTICE_CHOICE;
        }

        /** 
         * Get the 'PricingParametersNotice' element value.
         * 
         * @return value
         */
        public PricingParametersNoticeType getPricingParametersNotice() {
            return pricingParametersNotice;
        }

        /** 
         * Set the 'PricingParametersNotice' element value.
         * 
         * @param pricingParametersNotice
         */
        public void setPricingParametersNotice(
                PricingParametersNoticeType pricingParametersNotice) {
            setNoticeListSelect(PRICING_PARAMETERS_NOTICE_CHOICE);
            this.pricingParametersNotice = pricingParametersNotice;
        }

        /** 
         * Check if PriceVarianceNotice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPriceVarianceNotice() {
            return noticeListSelect == PRICE_VARIANCE_NOTICE_CHOICE;
        }

        /** 
         * Get the 'PriceVarianceNotice' element value. Price Variance Rule(s) Notice. Note: Supports specifying Payment Processing Rules, including payment failure. Request messages may include defined payment processing rules and an indicator requesting that the rules be applied during payment processing where relevant. Response messages may additionally include notice about if and how payment rule(s) were applied during transaction processing.
          
         * 
         * @return value
         */
        public PriceVarianceRuleNoticeType getPriceVarianceNotice() {
            return priceVarianceNotice;
        }

        /** 
         * Set the 'PriceVarianceNotice' element value. Price Variance Rule(s) Notice. Note: Supports specifying Payment Processing Rules, including payment failure. Request messages may include defined payment processing rules and an indicator requesting that the rules be applied during payment processing where relevant. Response messages may additionally include notice about if and how payment rule(s) were applied during transaction processing.
          
         * 
         * @param priceVarianceNotice
         */
        public void setPriceVarianceNotice(
                PriceVarianceRuleNoticeType priceVarianceNotice) {
            setNoticeListSelect(PRICE_VARIANCE_NOTICE_CHOICE);
            this.priceVarianceNotice = priceVarianceNotice;
        }

        /** 
         * Check if PaymentRulesNotice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPaymentRulesNotice() {
            return noticeListSelect == PAYMENT_RULES_NOTICE_CHOICE;
        }

        /** 
         * Get the 'PaymentRulesNotice' element value.
         * 
         * @return value
         */
        public PaymentRulesNoticeType getPaymentRulesNotice() {
            return paymentRulesNotice;
        }

        /** 
         * Set the 'PaymentRulesNotice' element value.
         * 
         * @param paymentRulesNotice
         */
        public void setPaymentRulesNotice(
                PaymentRulesNoticeType paymentRulesNotice) {
            setNoticeListSelect(PAYMENT_RULES_NOTICE_CHOICE);
            this.paymentRulesNotice = paymentRulesNotice;
        }

        /** 
         * Check if InventoryGuaranteeNotif is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifInventoryGuaranteeNotif() {
            return noticeListSelect == INVENTORY_GUARANTEE_NOTIF_CHOICE;
        }

        /** 
         * Get the 'InventoryGuaranteeNotif' element value.
         * 
         * @return value
         */
        public InvGuaranteeNoticeType getInventoryGuaranteeNotif() {
            return inventoryGuaranteeNotif;
        }

        /** 
         * Set the 'InventoryGuaranteeNotif' element value.
         * 
         * @param inventoryGuaranteeNotif
         */
        public void setInventoryGuaranteeNotif(
                InvGuaranteeNoticeType inventoryGuaranteeNotif) {
            setNoticeListSelect(INVENTORY_GUARANTEE_NOTIF_CHOICE);
            this.inventoryGuaranteeNotif = inventoryGuaranteeNotif;
        }
    }
}
