
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Policy, unique instance id, object metadata and other object associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjectKeyMetaAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ObjectKey"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ObjectKeyMetaAttrGroup implements Serializable
{
    private String refs;
    private String objectKey;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @return value
     */
    public String getObjectKey() {
        return objectKey;
    }

    /** 
     * Set the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @param objectKey
     */
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }
}
