
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Policy, object metadata and other object associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjectPolicyMetaAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ObjectMetaReferences"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ObjectPolicyMetaAttrGroup implements Serializable
{
    private String refs;
    private String objectMetaReferences;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ObjectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
     * 
     * @return value
     */
    public String getObjectMetaReferences() {
        return objectMetaReferences;
    }

    /** 
     * Set the 'ObjectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
     * 
     * @param objectMetaReferences
     */
    public void setObjectMetaReferences(String objectMetaReferences) {
        this.objectMetaReferences = objectMetaReferences;
    }
}
