
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Offer Geographic Specification information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferGeographicSpecificationType">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="ns:GeographicSpecificationType" name="TravelWithin" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferGeographicSpecificationType implements Serializable
{
    private int choiceSelect = -1;
    private static final int SEQUENCE_CHOICE = 0;
    private static final int TRAVEL_WITHIN_CHOICE = 1;
    private Sequence sequence;
    private GeographicSpecificationType travelWithin;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Sequence is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSequence() {
        return choiceSelect == SEQUENCE_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        setChoiceSelect(SEQUENCE_CHOICE);
        this.sequence = sequence;
    }

    /** 
     * Check if TravelWithin is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelWithin() {
        return choiceSelect == TRAVEL_WITHIN_CHOICE;
    }

    /** 
     * Get the 'TravelWithin' element value. Specifies that all travel on the itinerary must be wholly within the specified location.
     * 
     * @return value
     */
    public GeographicSpecificationType getTravelWithin() {
        return travelWithin;
    }

    /** 
     * Set the 'TravelWithin' element value. Specifies that all travel on the itinerary must be wholly within the specified location.
     * 
     * @param travelWithin
     */
    public void setTravelWithin(GeographicSpecificationType travelWithin) {
        setChoiceSelect(TRAVEL_WITHIN_CHOICE);
        this.travelWithin = travelWithin;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element name="DirectionalIndicator" minOccurs="0">
     *     &lt;xs:simpleType>
     *       &lt;!-- Reference to inner class DirectionalIndicator -->
     *     &lt;/xs:simpleType>
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:GeographicSpecificationType" name="OfferOriginPoint" minOccurs="0"/>
     *   &lt;xs:element type="ns:GeographicSpecificationType" name="OfferDestinationPoint" minOccurs="0"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private DirectionalIndicator directionalIndicator;
        private GeographicSpecificationType offerOriginPoint;
        private GeographicSpecificationType offerDestinationPoint;

        /** 
         * Get the 'DirectionalIndicator' element value. 1 = From LOC 1 to LOC 2   2 = To LOC 1 from LOC 2    3 = Both
         * 
         * @return value
         */
        public DirectionalIndicator getDirectionalIndicator() {
            return directionalIndicator;
        }

        /** 
         * Set the 'DirectionalIndicator' element value. 1 = From LOC 1 to LOC 2   2 = To LOC 1 from LOC 2    3 = Both
         * 
         * @param directionalIndicator
         */
        public void setDirectionalIndicator(
                DirectionalIndicator directionalIndicator) {
            this.directionalIndicator = directionalIndicator;
        }

        /** 
         * Get the 'OfferOriginPoint' element value. Identifies the Offer Origin Point.
         * 
         * @return value
         */
        public GeographicSpecificationType getOfferOriginPoint() {
            return offerOriginPoint;
        }

        /** 
         * Set the 'OfferOriginPoint' element value. Identifies the Offer Origin Point.
         * 
         * @param offerOriginPoint
         */
        public void setOfferOriginPoint(
                GeographicSpecificationType offerOriginPoint) {
            this.offerOriginPoint = offerOriginPoint;
        }

        /** 
         * Get the 'OfferDestinationPoint' element value. Identifies the Offer Destination Point.
         * 
         * @return value
         */
        public GeographicSpecificationType getOfferDestinationPoint() {
            return offerDestinationPoint;
        }

        /** 
         * Set the 'OfferDestinationPoint' element value. Identifies the Offer Destination Point.
         * 
         * @param offerDestinationPoint
         */
        public void setOfferDestinationPoint(
                GeographicSpecificationType offerDestinationPoint) {
            this.offerDestinationPoint = offerDestinationPoint;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="From LOC1 to LOC2"/>
         *     &lt;xs:enumeration value="To LOC1 from LOC2"/>
         *     &lt;xs:enumeration value="Both"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum DirectionalIndicator implements Serializable {
            FROM_LO_C1TO_LO_C2("From LOC1 to LOC2"), TO_LO_C1FROM_LO_C2(
                    "To LOC1 from LOC2"), BOTH("Both");
            private final String value;

            private DirectionalIndicator(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static DirectionalIndicator convert(String value) {
                for (DirectionalIndicator inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
}
