
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * MINIMUM/ MAXIMUM GROUP SIZE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferGroupSizeType">
 *   &lt;xs:choice maxOccurs="2">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferGroupSizeType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();

    /** 
     * Get the list of 'OfferGroupSizeType' complexType items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of 'OfferGroupSizeType' complexType items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
     *   &lt;xs:element type="xs:string" name="Minimum"/>
     *   &lt;xs:element type="xs:string" name="Maximum"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int MINIMUM_CHOICE = 0;
        private static final int MAXIMUM_CHOICE = 1;
        private String minimum;
        private String maximum;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if Minimum is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMinimum() {
            return choiceListSelect == MINIMUM_CHOICE;
        }

        /** 
         * Get the 'Minimum' element value. The MINIMUM Group Size (e.g. Traveler quantity) required for the Offer.  Example: 2
         * 
         * @return value
         */
        public String getMinimum() {
            return minimum;
        }

        /** 
         * Set the 'Minimum' element value. The MINIMUM Group Size (e.g. Traveler quantity) required for the Offer.  Example: 2
         * 
         * @param minimum
         */
        public void setMinimum(String minimum) {
            setChoiceListSelect(MINIMUM_CHOICE);
            this.minimum = minimum;
        }

        /** 
         * Check if Maximum is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMaximum() {
            return choiceListSelect == MAXIMUM_CHOICE;
        }

        /** 
         * Get the 'Maximum' element value. The MAXIMUM Group Size (e.g. Traveler quantity) required for the Offer.  Example: 6
         * 
         * @return value
         */
        public String getMaximum() {
            return maximum;
        }

        /** 
         * Set the 'Maximum' element value. The MAXIMUM Group Size (e.g. Traveler quantity) required for the Offer.  Example: 6
         * 
         * @param maximum
         */
        public void setMaximum(String maximum) {
            setChoiceListSelect(MAXIMUM_CHOICE);
            this.maximum = maximum;
        }
    }
}
