
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Offer Instructions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferInstructionType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:InstrClassUpgradeType" name="ClassOfServiceUpgrade"/>
 *     &lt;xs:element type="ns:RemarkType" name="FreeFormTextInstruction"/>
 *     &lt;xs:element type="xs:string" name="SpecialBookingInstruction"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferInstructionType implements Serializable
{
    private int choiceSelect = -1;
    private static final int CLASS_OF_SERVICE_UPGRADE_CHOICE = 0;
    private static final int FREE_FORM_TEXT_INSTRUCTION_CHOICE = 1;
    private static final int SPECIAL_BOOKING_INSTRUCTION_CHOICE = 2;
    private InstrClassUpgradeType classOfServiceUpgrade;
    private RemarkType freeFormTextInstruction;
    private String specialBookingInstruction;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ClassOfServiceUpgrade is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifClassOfServiceUpgrade() {
        return choiceSelect == CLASS_OF_SERVICE_UPGRADE_CHOICE;
    }

    /** 
     * Get the 'ClassOfServiceUpgrade' element value. Upgrade-eligible Class(es) of Service.
     * 
     * @return value
     */
    public InstrClassUpgradeType getClassOfServiceUpgrade() {
        return classOfServiceUpgrade;
    }

    /** 
     * Set the 'ClassOfServiceUpgrade' element value. Upgrade-eligible Class(es) of Service.
     * 
     * @param classOfServiceUpgrade
     */
    public void setClassOfServiceUpgrade(
            InstrClassUpgradeType classOfServiceUpgrade) {
        setChoiceSelect(CLASS_OF_SERVICE_UPGRADE_CHOICE);
        this.classOfServiceUpgrade = classOfServiceUpgrade;
    }

    /** 
     * Check if FreeFormTextInstruction is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFreeFormTextInstruction() {
        return choiceSelect == FREE_FORM_TEXT_INSTRUCTION_CHOICE;
    }

    /** 
     * Get the 'FreeFormTextInstruction' element value. Free-text Instruction Remark(s).
     * 
     * @return value
     */
    public RemarkType getFreeFormTextInstruction() {
        return freeFormTextInstruction;
    }

    /** 
     * Set the 'FreeFormTextInstruction' element value. Free-text Instruction Remark(s).
     * 
     * @param freeFormTextInstruction
     */
    public void setFreeFormTextInstruction(RemarkType freeFormTextInstruction) {
        setChoiceSelect(FREE_FORM_TEXT_INSTRUCTION_CHOICE);
        this.freeFormTextInstruction = freeFormTextInstruction;
    }

    /** 
     * Check if SpecialBookingInstruction is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSpecialBookingInstruction() {
        return choiceSelect == SPECIAL_BOOKING_INSTRUCTION_CHOICE;
    }

    /** 
     * Get the 'SpecialBookingInstruction' element value. Special Need Order booking method.
    Examples:
    AE (by SSR-Special Service Request)
    AF (by OSI-Other Service Information)

    Encoding scheme: PADIS Code List for data element 9750 - Option
     * 
     * @return value
     */
    public String getSpecialBookingInstruction() {
        return specialBookingInstruction;
    }

    /** 
     * Set the 'SpecialBookingInstruction' element value. Special Need Order booking method.
    Examples:
    AE (by SSR-Special Service Request)
    AF (by OSI-Other Service Information)

    Encoding scheme: PADIS Code List for data element 9750 - Option
     * 
     * @param specialBookingInstruction
     */
    public void setSpecialBookingInstruction(String specialBookingInstruction) {
        setChoiceSelect(SPECIAL_BOOKING_INSTRUCTION_CHOICE);
        this.specialBookingInstruction = specialBookingInstruction;
    }
}
