
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OFFER ITEM METADATA definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="ATPCO" minOccurs="0">
 *           &lt;!-- Reference to inner class ATPCO -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:OfferIncentiveType" name="Incentives" minOccurs="0"/>
 *         &lt;xs:element name="Matches" minOccurs="0">
 *           &lt;!-- Reference to inner class Matches -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Terms" minOccurs="0">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="TimeLimits" minOccurs="0">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Rule" minOccurs="0">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:OfferStatusType" name="Status" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private ATPCO ATPCO1;
    private OfferIncentiveType incentives;
    private Matches matches;
    private AugPointInfoType terms;
    private AugPointInfoType timeLimits;
    private AugPointInfoType rule;
    private OfferStatusType status;

    /** 
     * Get the 'ATPCO' element value.
     * 
     * @return value
     */
    public ATPCO getATPCO1() {
        return ATPCO1;
    }

    /** 
     * Set the 'ATPCO' element value.
     * 
     * @param ATPCO1
     */
    public void setATPCO1(ATPCO ATPCO1) {
        this.ATPCO1 = ATPCO1;
    }

    /** 
     * Get the 'Incentives' element value. Offer Incentive(s).
     * 
     * @return value
     */
    public OfferIncentiveType getIncentives() {
        return incentives;
    }

    /** 
     * Set the 'Incentives' element value. Offer Incentive(s).
     * 
     * @param incentives
     */
    public void setIncentives(OfferIncentiveType incentives) {
        this.incentives = incentives;
    }

    /** 
     * Get the 'Matches' element value.
     * 
     * @return value
     */
    public Matches getMatches() {
        return matches;
    }

    /** 
     * Set the 'Matches' element value.
     * 
     * @param matches
     */
    public void setMatches(Matches matches) {
        this.matches = matches;
    }

    /** 
     * Get the 'AugmentationPoint' element value. Offer Terms.
     * 
     * @return value
     */
    public AugPointInfoType getTerms() {
        return terms;
    }

    /** 
     * Set the 'AugmentationPoint' element value. Offer Terms.
     * 
     * @param terms
     */
    public void setTerms(AugPointInfoType terms) {
        this.terms = terms;
    }

    /** 
     * Get the 'AugmentationPoint' element value. Offer Time Limits.
     * 
     * @return value
     */
    public AugPointInfoType getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'AugmentationPoint' element value. Offer Time Limits.
     * 
     * @param timeLimits
     */
    public void setTimeLimits(AugPointInfoType timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'AugmentationPoint' element value. Offer Rules.
     * 
     * @return value
     */
    public AugPointInfoType getRule() {
        return rule;
    }

    /** 
     * Set the 'AugmentationPoint' element value. Offer Rules.
     * 
     * @param rule
     */
    public void setRule(AugPointInfoType rule) {
        this.rule = rule;
    }

    /** 
     * Get the 'Status' element value. Offer Status. Example: NN (Requested)
     * 
     * @return value
     */
    public OfferStatusType getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Offer Status. Example: NN (Requested)
     * 
     * @param status
     */
    public void setStatus(OfferStatusType status) {
        this.status = status;
    }
    /** 
     * Attributes and S5/ S7 Diagnostics.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ATPCO" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:Attributes" minOccurs="0"/>
     *       &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ATPCO implements Serializable
    {
        private AttributesType attributes;
        private AugPointInfoType augmentationPoint;

        /** 
         * Get the 'Attributes' element value.
         * 
         * @return value
         */
        public AttributesType getAttributes() {
            return attributes;
        }

        /** 
         * Set the 'Attributes' element value.
         * 
         * @param attributes
         */
        public void setAttributes(AttributesType attributes) {
            this.attributes = attributes;
        }

        /** 
         * Get the 'AugmentationPoint' element value.
         * 
         * @return value
         */
        public AugPointInfoType getAugmentationPoint() {
            return augmentationPoint;
        }

        /** 
         * Set the 'AugmentationPoint' element value.
         * 
         * @param augmentationPoint
         */
        public void setAugmentationPoint(AugPointInfoType augmentationPoint) {
            this.augmentationPoint = augmentationPoint;
        }
    }
    /** 
     * Offer Match(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Matches" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Match" maxOccurs="unbounded">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Matches implements Serializable
    {
        private List<AugPointInfoType> matchList = new ArrayList<AugPointInfoType>();

        /** 
         * Get the list of 'Match' element items. Offer Match detail.
         * 
         * @return list
         */
        public List<AugPointInfoType> getMatchList() {
            return matchList;
        }

        /** 
         * Set the list of 'Match' element items. Offer Match detail.
         * 
         * @param list
         */
        public void setMatchList(List<AugPointInfoType> list) {
            matchList = list;
        }
    }
}
