
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Lead Pricing Price Detail definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferPriceLeadDetailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="PriceDetail">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="TotalAmount" minOccurs="0">
 *             &lt;!-- Reference to inner class TotalAmount -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount"/>
 *           &lt;xs:element ref="ns:FareFiledIn" minOccurs="0"/>
 *           &lt;xs:element type="ns:DiscountType" name="Discount" minOccurs="0"/>
 *           &lt;xs:element name="Surcharges" minOccurs="0">
 *             &lt;!-- Reference to inner class Surcharges -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
 *           &lt;xs:element ref="ns:TaxExemption" minOccurs="0"/>
 *           &lt;xs:choice>
 *             &lt;xs:element type="ns:AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
 *             &lt;xs:element type="ns:CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
 *           &lt;/xs:choice>
 *           &lt;xs:choice minOccurs="0" maxOccurs="2">
 *             &lt;!-- Reference to inner class Choice -->
 *           &lt;/xs:choice>
 *           &lt;xs:element type="ns:FeeSurchargeType" name="Fees" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferPriceLeadDetailType implements Serializable
{
    private TotalAmount totalAmount;
    private CurrencyAmountOptType priceDetailBaseAmount;
    private FareFilingType priceDetailFareFiledIn;
    private DiscountType priceDetailDiscount;
    private Surcharges surcharges;
    private TaxDetailType priceDetailTaxes;
    private TaxExemptionType priceDetailTaxExemption;
    private int priceDetailChoiceSelect = -1;
    private static final int PRICE_DETAIL_AWARD_PRICING_CHOICE = 0;
    private static final int PRICE_DETAIL_COMBINATION_PRICING_CHOICE = 1;
    private AwardPriceUnitType priceDetailAwardPricing;
    private CombinationPriceType priceDetailCombinationPricing;
    private List<Choice> choiceList = new ArrayList<Choice>();
    private FeeSurchargeType priceDetailFees;

    /** 
     * Get the 'TotalAmount' element value. Price Detail, including total amount, base fare amount and other details.
     * 
     * @return value
     */
    public TotalAmount getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Price Detail, including total amount, base fare amount and other details.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(TotalAmount totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getPriceDetailBaseAmount() {
        return priceDetailBaseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param priceDetailBaseAmount
     */
    public void setPriceDetailBaseAmount(
            CurrencyAmountOptType priceDetailBaseAmount) {
        this.priceDetailBaseAmount = priceDetailBaseAmount;
    }

    /** 
     * Get the 'FareFiledIn' element value.
     * 
     * @return value
     */
    public FareFilingType getPriceDetailFareFiledIn() {
        return priceDetailFareFiledIn;
    }

    /** 
     * Set the 'FareFiledIn' element value.
     * 
     * @param priceDetailFareFiledIn
     */
    public void setPriceDetailFareFiledIn(FareFilingType priceDetailFareFiledIn) {
        this.priceDetailFareFiledIn = priceDetailFareFiledIn;
    }

    /** 
     * Get the 'Discount' element value. Discount Information
     * 
     * @return value
     */
    public DiscountType getPriceDetailDiscount() {
        return priceDetailDiscount;
    }

    /** 
     * Set the 'Discount' element value. Discount Information
     * 
     * @param priceDetailDiscount
     */
    public void setPriceDetailDiscount(DiscountType priceDetailDiscount) {
        this.priceDetailDiscount = priceDetailDiscount;
    }

    /** 
     * Get the 'Surcharges' element value. Price Detail, including total amount, base fare amount and other details.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value. Price Detail, including total amount, base fare amount and other details.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.

     * 
     * @return value
     */
    public TaxDetailType getPriceDetailTaxes() {
        return priceDetailTaxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.

     * 
     * @param priceDetailTaxes
     */
    public void setPriceDetailTaxes(TaxDetailType priceDetailTaxes) {
        this.priceDetailTaxes = priceDetailTaxes;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public TaxExemptionType getPriceDetailTaxExemption() {
        return priceDetailTaxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param priceDetailTaxExemption
     */
    public void setPriceDetailTaxExemption(
            TaxExemptionType priceDetailTaxExemption) {
        this.priceDetailTaxExemption = priceDetailTaxExemption;
    }

    private void setPriceDetailChoiceSelect(int choice) {
        if (priceDetailChoiceSelect == -1) {
            priceDetailChoiceSelect = choice;
        } else if (priceDetailChoiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearPriceDetailChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearPriceDetailChoiceSelect() {
        priceDetailChoiceSelect = -1;
    }

    /** 
     * Check if PriceDetailAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceDetailAwardPricing() {
        return priceDetailChoiceSelect == PRICE_DETAIL_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @return value
     */
    public AwardPriceUnitType getPriceDetailAwardPricing() {
        return priceDetailAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @param priceDetailAwardPricing
     */
    public void setPriceDetailAwardPricing(
            AwardPriceUnitType priceDetailAwardPricing) {
        setPriceDetailChoiceSelect(PRICE_DETAIL_AWARD_PRICING_CHOICE);
        this.priceDetailAwardPricing = priceDetailAwardPricing;
    }

    /** 
     * Check if PriceDetailCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceDetailCombinationPricing() {
        return priceDetailChoiceSelect == PRICE_DETAIL_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @return value
     */
    public CombinationPriceType getPriceDetailCombinationPricing() {
        return priceDetailCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @param priceDetailCombinationPricing
     */
    public void setPriceDetailCombinationPricing(
            CombinationPriceType priceDetailCombinationPricing) {
        setPriceDetailChoiceSelect(PRICE_DETAIL_COMBINATION_PRICING_CHOICE);
        this.priceDetailCombinationPricing = priceDetailCombinationPricing;
    }

    /** 
     * Get the list of choice items. Price Detail, including total amount, base fare amount and other details.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of choice items. Price Detail, including total amount, base fare amount and other details.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getPriceDetailFees() {
        return priceDetailFees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param priceDetailFees
     */
    public void setPriceDetailFees(FeeSurchargeType priceDetailFees) {
        this.priceDetailFees = priceDetailFees;
    }
    /** 
     * Total price amount.

    Notes:
    1. This is typically the lowest price for this alternate lead shopping date.
    2. If expressed in currency, this price should include base price, taxes and fees/ surcharges.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalAmount" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalAmount implements Serializable
    {
        private int totalAmountSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private static final int DETAIL_CURRENCY_PRICE_CHOICE = 2;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 3;
        private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private SimpleCurrencyPrice simpleCurrencyPrice;

        private void setTotalAmountSelect(int choice) {
            if (totalAmountSelect == -1) {
                totalAmountSelect = choice;
            } else if (totalAmountSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearTotalAmountSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearTotalAmountSelect() {
            totalAmountSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return totalAmountSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setTotalAmountSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return totalAmountSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setTotalAmountSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Check if DetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDetailCurrencyPrice() {
            return totalAmountSelect == DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            setTotalAmountSelect(DETAIL_CURRENCY_PRICE_CHOICE);
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return totalAmountSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setTotalAmountSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Check if SimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleCurrencyPrice() {
            return totalAmountSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            setTotalAmountSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="2">
     *   &lt;xs:element ref="ns:OriginDestinationReference"/>
     *   &lt;xs:element ref="ns:SegmentReferences"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int ORIGIN_DESTINATION_REFERENCE_CHOICE = 0;
        private static final int SEGMENT_REFERENCES_CHOICE = 1;
        private OriginDestinationReference originDestinationReference;
        private SegmentReferences segmentReferences;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if OriginDestinationReference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginDestinationReference() {
            return choiceListSelect == ORIGIN_DESTINATION_REFERENCE_CHOICE;
        }

        /** 
         * Get the 'OriginDestinationReference' element value.
         * 
         * @return value
         */
        public OriginDestinationReference getOriginDestinationReference() {
            return originDestinationReference;
        }

        /** 
         * Set the 'OriginDestinationReference' element value.
         * 
         * @param originDestinationReference
         */
        public void setOriginDestinationReference(
                OriginDestinationReference originDestinationReference) {
            setChoiceListSelect(ORIGIN_DESTINATION_REFERENCE_CHOICE);
            this.originDestinationReference = originDestinationReference;
        }

        /** 
         * Check if SegmentReferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSegmentReferences() {
            return choiceListSelect == SEGMENT_REFERENCES_CHOICE;
        }

        /** 
         * Get the 'SegmentReferences' element value.
         * 
         * @return value
         */
        public SegmentReferences getSegmentReferences() {
            return segmentReferences;
        }

        /** 
         * Set the 'SegmentReferences' element value.
         * 
         * @param segmentReferences
         */
        public void setSegmentReferences(SegmentReferences segmentReferences) {
            setChoiceListSelect(SEGMENT_REFERENCES_CHOICE);
            this.segmentReferences = segmentReferences;
        }
    }
}
