
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * On-time performance for this flight Segment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OnTimePerformance">
 *   &lt;xs:complexType>
 *     &lt;xs:attribute type="xs:decimal" use="optional" name="Percent"/>
 *     &lt;xs:attribute type="xs:string" use="required" name="Period"/>
 *     &lt;xs:attribute type="xs:string" name="Type"/>
 *     &lt;xs:attribute type="xs:decimal" name="LatePercent"/>
 *     &lt;xs:attribute type="xs:decimal" name="CancelledPercent"/>
 *     &lt;xs:attribute type="xs:boolean" name="SpecialHighlightInd"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OnTimePerformance implements Serializable
{
    private BigDecimal percent;
    private String period;
    private String type;
    private BigDecimal latePercent;
    private BigDecimal cancelledPercent;
    private Boolean specialHighlightInd;

    /** 
     * Get the 'Percent' attribute value. Accuracy percentage of on time performance of a leg.
     * 
     * @return value
     */
    public BigDecimal getPercent() {
        return percent;
    }

    /** 
     * Set the 'Percent' attribute value. Accuracy percentage of on time performance of a leg.
     * 
     * @param percent
     */
    public void setPercent(BigDecimal percent) {
        this.percent = percent;
    }

    /** 
     * Get the 'Period' attribute value. Month and year for which the on-time performance has been calculated.
     * 
     * @return value
     */
    public String getPeriod() {
        return period;
    }

    /** 
     * Set the 'Period' attribute value. Month and year for which the on-time performance has been calculated.
     * 
     * @param period
     */
    public void setPeriod(String period) {
        this.period = period;
    }

    /** 
     * Get the 'Type' attribute value. Used if unable to provide information or is not applicable.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Used if unable to provide information or is not applicable.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'LatePercent' attribute value. The percentage of arrivals that were more than 30 minutes late.
     * 
     * @return value
     */
    public BigDecimal getLatePercent() {
        return latePercent;
    }

    /** 
     * Set the 'LatePercent' attribute value. The percentage of arrivals that were more than 30 minutes late.
     * 
     * @param latePercent
     */
    public void setLatePercent(BigDecimal latePercent) {
        this.latePercent = latePercent;
    }

    /** 
     * Get the 'CancelledPercent' attribute value. The percentage of cancellations.
     * 
     * @return value
     */
    public BigDecimal getCancelledPercent() {
        return cancelledPercent;
    }

    /** 
     * Set the 'CancelledPercent' attribute value. The percentage of cancellations.
     * 
     * @param cancelledPercent
     */
    public void setCancelledPercent(BigDecimal cancelledPercent) {
        this.cancelledPercent = cancelledPercent;
    }

    /** 
     * Get the 'SpecialHighlightInd' attribute value. When true, the flight was late more than 30 minutes of scheduled arrival more than 50 percent of the time.
     * 
     * @return value
     */
    public Boolean getSpecialHighlightInd() {
        return specialHighlightInd;
    }

    /** 
     * Set the 'SpecialHighlightInd' attribute value. When true, the flight was late more than 30 minutes of scheduled arrival more than 50 percent of the time.
     * 
     * @param specialHighlightInd
     */
    public void setSpecialHighlightInd(Boolean specialHighlightInd) {
        this.specialHighlightInd = specialHighlightInd;
    }
}
